/**
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Véronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program “Beem”
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.jingle;

import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;

// TODO: Auto-generated Javadoc
/**
 * Transmit Microphone data through RTP.
 * @author nikita
 */
public class PCMTransmitter extends RTPTransmitter {

    private static final int BUFF_SIZE = 1024;
    private static final int RATE_IN_HZ = 8000;
    private static final int SLP_DURATION = 200;

    /**
     * Constructor.
     * @param remoteIP receiver IP.
     * @param remotePort receiver port.
     */
    public PCMTransmitter(final String remoteIP, final int remotePort) {
	super(remoteIP, remotePort);
    }

    /* (non-Javadoc)
     * @see com.beem.project.beem.jingle.RTPTransmitter#start()
     */
    @Override
    void start() {
	AudioRecord audRec = new AudioRecord(MediaRecorder.AudioSource.DEFAULT, RATE_IN_HZ,
	    AudioFormat.CHANNEL_CONFIGURATION_MONO, AudioFormat.ENCODING_PCM_16BIT, AudioRecord.getMinBufferSize(
		RATE_IN_HZ, AudioFormat.CHANNEL_CONFIGURATION_MONO, AudioFormat.ENCODING_PCM_16BIT) * 4);
	byte[] audioData = new byte[BUFF_SIZE];
	int byteReaded = 0;
	while (!isKillme()) {
	    byteReaded = audRec.read(audioData, byteReaded, BUFF_SIZE);
	    System.out.println("readed " + byteReaded);
	    getRtpSession().sendData(audioData);
	}
	try {
	    Thread.sleep(SLP_DURATION);
	} catch (InterruptedException e) {
	    e.printStackTrace();
	}
	this.getRtpSession().endSession();
    }
}
