/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class Gateway {
    private Connection connection;
    private ServiceDiscoveryManager sdManager;
    private Roster roster;
    private String entityJID;
    private Registration registerInfo;
    private DiscoverInfo.Identity identity;
    private DiscoverInfo info;

    Gateway(Connection connection, String string) {
        this.connection = connection;
        this.roster = connection.getRoster();
        this.sdManager = ServiceDiscoveryManager.getInstanceFor(connection);
        this.entityJID = string;
    }

    Gateway(Connection connection, String string, DiscoverInfo discoverInfo, DiscoverInfo.Identity identity) {
        this(connection, string);
        this.info = discoverInfo;
        this.identity = identity;
    }

    private void discoverInfo() throws XMPPException {
        this.info = this.sdManager.discoverInfo(this.entityJID);
        Iterator<DiscoverInfo.Identity> iterator = this.info.getIdentities();
        while (iterator.hasNext()) {
            DiscoverInfo.Identity identity = iterator.next();
            if (!identity.getCategory().equalsIgnoreCase("gateway")) continue;
            this.identity = identity;
            break;
        }
    }

    private DiscoverInfo.Identity getIdentity() throws XMPPException {
        if (this.identity == null) {
            this.discoverInfo();
        }
        return this.identity;
    }

    private Registration getRegisterInfo() {
        if (this.registerInfo == null) {
            this.refreshRegisterInfo();
        }
        return this.registerInfo;
    }

    private void refreshRegisterInfo() {
        Registration registration = new Registration();
        registration.setFrom(this.connection.getUser());
        registration.setType(IQ.Type.GET);
        registration.setTo(this.entityJID);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(registration.getPacketID()));
        this.connection.sendPacket(registration);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet instanceof Registration && packet.getError() == null) {
            Registration registration2;
            this.registerInfo = registration2 = (Registration)packet;
        }
    }

    public boolean canRegister() throws XMPPException {
        if (this.info == null) {
            this.discoverInfo();
        }
        return this.info.containsFeature("jabber:iq:register");
    }

    public List<String> getRequiredFields() {
        return this.getRegisterInfo().getRequiredFields();
    }

    public String getName() throws XMPPException {
        if (this.identity == null) {
            this.discoverInfo();
        }
        return this.identity.getName();
    }

    public String getType() throws XMPPException {
        if (this.identity == null) {
            this.discoverInfo();
        }
        return this.identity.getType();
    }

    public boolean isRegistered() throws XMPPException {
        return this.getRegisterInfo().isRegistered();
    }

    public String getField(String string) {
        return this.getRegisterInfo().getField(string);
    }

    public List<String> getFieldNames() {
        return this.getRegisterInfo().getFieldNames();
    }

    public String getUsername() {
        return this.getField("username");
    }

    public String getPassword() {
        return this.getField("password");
    }

    public String getInstructions() {
        return this.getRegisterInfo().getInstructions();
    }

    public void register(String string, String string2, Map<String, String> map) throws XMPPException {
        if (this.getRegisterInfo().isRegistered()) {
            throw new IllegalStateException("You are already registered with this gateway");
        }
        Registration registration = new Registration();
        registration.setFrom(this.connection.getUser());
        registration.setTo(this.entityJID);
        registration.setType(IQ.Type.SET);
        registration.setUsername(string);
        registration.setPassword(string2);
        for (String object2 : map.keySet()) {
            registration.addAttribute(object2, map.get(object2));
        }
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(registration.getPacketID()));
        this.connection.sendPacket(registration);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet != null && packet instanceof IQ) {
            IQ iQ = (IQ)packet;
            if (iQ.getError() != null) {
                throw new XMPPException(iQ.getError());
            }
            if (iQ.getType() == IQ.Type.ERROR) {
                throw new XMPPException(iQ.getError());
            }
        } else {
            throw new XMPPException("Packet reply timeout");
        }
        this.connection.addPacketListener(new GatewayPresenceListener(), new PacketTypeFilter(Presence.class));
        this.roster.createEntry(this.entityJID, this.getIdentity().getName(), new String[0]);
    }

    public void register(String string, String string2) throws XMPPException {
        this.register(string, string2, new HashMap<String, String>());
    }

    public void unregister() throws XMPPException {
        Registration registration = new Registration();
        registration.setFrom(this.connection.getUser());
        registration.setTo(this.entityJID);
        registration.setType(IQ.Type.SET);
        registration.setRemove(true);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(registration.getPacketID()));
        this.connection.sendPacket(registration);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet != null && packet instanceof IQ) {
            IQ iQ = (IQ)packet;
            if (iQ.getError() != null) {
                throw new XMPPException(iQ.getError());
            }
            if (iQ.getType() == IQ.Type.ERROR) {
                throw new XMPPException(iQ.getError());
            }
        } else {
            throw new XMPPException("Packet reply timeout");
        }
        RosterEntry rosterEntry = this.roster.getEntry(this.entityJID);
        this.roster.removeEntry(rosterEntry);
    }

    public void login() {
        Presence presence = new Presence(Presence.Type.available);
        this.login(presence);
    }

    public void login(Presence presence) {
        presence.setType(Presence.Type.available);
        presence.setTo(this.entityJID);
        presence.setFrom(this.connection.getUser());
        this.connection.sendPacket(presence);
    }

    public void logout() {
        Presence presence = new Presence(Presence.Type.unavailable);
        presence.setTo(this.entityJID);
        presence.setFrom(this.connection.getUser());
        this.connection.sendPacket(presence);
    }

    private class GatewayPresenceListener
    implements PacketListener {
        private GatewayPresenceListener() {
        }

        @Override
        public void processPacket(Packet packet) {
            if (packet instanceof Presence) {
                Presence presence = (Presence)packet;
                if (Gateway.this.entityJID.equals(presence.getFrom()) && Gateway.this.roster.contains(presence.getFrom()) && presence.getType().equals((Object)Presence.Type.subscribe)) {
                    Presence presence2 = new Presence(Presence.Type.subscribed);
                    presence2.setTo(presence.getFrom());
                    presence2.setFrom(StringUtils.parseBareAddress(Gateway.this.connection.getUser()));
                    Gateway.this.connection.sendPacket(presence2);
                }
            }
        }
    }
}

