/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.packet.JingleContent;
import org.jivesoftware.smackx.packet.JingleContentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jingle
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String NODENAME = "jingle";
    private String sid;
    private JingleActionEnum action;
    private String initiator;
    private String responder;
    private final List<JingleContent> contents = new ArrayList<JingleContent>();
    private JingleContentInfo contentInfo;

    public Jingle(List<JingleContent> contents, JingleContentInfo mi, String sid) {
        if (contents != null) {
            contents.addAll(contents);
        }
        this.setContentInfo(mi);
        this.setSid(sid);
        this.initiator = null;
        this.responder = null;
        this.action = null;
    }

    public Jingle(JingleContent content) {
        this.addContent(content);
        this.initiator = null;
        this.responder = null;
        this.action = JingleActionEnum.UNKNOWN;
        this.setType(IQ.Type.SET);
    }

    public Jingle(JingleContentInfo info) {
        this.setContentInfo(info);
        this.initiator = null;
        this.responder = null;
        this.action = JingleActionEnum.UNKNOWN;
        this.setType(IQ.Type.SET);
    }

    public Jingle(JingleActionEnum action) {
        this(null, null, null);
        this.action = action;
        this.setType(IQ.Type.SET);
    }

    public Jingle(String sid) {
        this(null, null, sid);
    }

    public Jingle() {
    }

    public final void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public static String getElementName() {
        return NODENAME;
    }

    public static String getNamespace() {
        return NAMESPACE;
    }

    public JingleContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(JingleContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<JingleContent> getContents() {
        List<JingleContent> list = this.contents;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<JingleContent>(this.contents)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleContent> getContentsList() {
        List<JingleContent> list = this.contents;
        synchronized (list) {
            return new ArrayList<JingleContent>(this.contents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(JingleContent content) {
        if (content != null) {
            List<JingleContent> list = this.contents;
            synchronized (list) {
                this.contents.add(content);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContents(List<JingleContent> contentList) {
        if (contentList != null) {
            List<JingleContent> list = this.contents;
            synchronized (list) {
                this.contents.addAll(contentList);
            }
        }
    }

    public JingleActionEnum getAction() {
        return this.action;
    }

    public void setAction(JingleActionEnum action) {
        this.action = action;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setResponder(String resp) {
        this.responder = resp;
    }

    public static int getSessionHash(String sid, String initiator) {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (initiator == null ? 0 : initiator.hashCode());
        result = 31 * result + (sid == null ? 0 : sid.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(Jingle.getElementName());
        buf.append(" xmlns=\"").append(Jingle.getNamespace()).append("\"");
        if (this.getInitiator() != null) {
            buf.append(" initiator=\"").append(this.getInitiator()).append("\"");
        }
        if (this.getResponder() != null) {
            buf.append(" responder=\"").append(this.getResponder()).append("\"");
        }
        if (this.getAction() != null) {
            buf.append(" action=\"").append((Object)this.getAction()).append("\"");
        }
        if (this.getSid() != null) {
            buf.append(" sid=\"").append(this.getSid()).append("\"");
        }
        buf.append(">");
        List<JingleContent> list = this.contents;
        synchronized (list) {
            for (JingleContent content : this.contents) {
                buf.append(content.toXML());
            }
        }
        if (this.contentInfo != null) {
            buf.append(this.contentInfo.toXML());
        }
        buf.append("</").append(Jingle.getElementName()).append(">");
        return buf.toString();
    }
}

