/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import org.jlibrtp.jlibrtp.StaticProcs;

public class RtpPkt {
    private boolean rawPktCurrent = false;
    private int version = 2;
    private int padding;
    private int extension = 0;
    private int marker = 0;
    private int payloadType;
    private int seqNumber;
    private long timeStamp;
    private long ssrc;
    private long[] csrcArray = null;
    private byte[] rawPkt = null;
    private byte[] payload = null;

    protected RtpPkt(long aTimeStamp, long syncSource, int seqNum, int plt, byte[] pl) {
        int test = 0;
        test += this.setTimeStamp(aTimeStamp);
        test += this.setSsrc(syncSource);
        test += this.setSeqNumber(seqNum);
        test += this.setPayloadType(plt);
        if ((test += this.setPayload(pl)) != 0) {
            System.out.println("RtpPkt() failed, check with checkPkt()");
        }
        this.rawPktCurrent = true;
    }

    protected RtpPkt(byte[] aRawPkt, int packetSize) {
        int remOct;
        if (aRawPkt == null) {
            System.out.println("RtpPkt(byte[]) Packet null");
        }
        if ((remOct = packetSize - 12) >= 0) {
            this.rawPkt = aRawPkt;
            this.sliceFirstLine();
            if (this.version == 2) {
                this.sliceTimeStamp();
                this.sliceSSRC();
                if (remOct > 4 && this.getCsrcCount() > 0) {
                    this.sliceCSRCs();
                    remOct -= this.csrcArray.length * 4;
                }
                if (remOct > 0) {
                    this.slicePayload(remOct);
                }
                this.checkPkt();
                this.rawPktCurrent = true;
            } else {
                System.out.println("RtpPkt(byte[]) Packet is not version 2, giving up.");
            }
        } else {
            System.out.println("RtpPkt(byte[]) Packet too small to be sliced");
        }
        this.rawPktCurrent = true;
    }

    protected int checkPkt() {
        return 0;
    }

    protected int getHeaderLength() {
        return 12 + 4 * this.getCsrcCount();
    }

    protected int getPayloadLength() {
        return this.payload.length;
    }

    protected int getVersion() {
        return this.version;
    }

    protected boolean isMarked() {
        return this.marker != 0;
    }

    protected int getPayloadType() {
        return this.payloadType;
    }

    protected int getSeqNumber() {
        return this.seqNumber;
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    protected long getSsrc() {
        return this.ssrc;
    }

    protected int getCsrcCount() {
        if (this.csrcArray != null) {
            return this.csrcArray.length;
        }
        return 0;
    }

    protected long[] getCsrcArray() {
        return this.csrcArray;
    }

    protected byte[] encode() {
        if (!this.rawPktCurrent || this.rawPkt == null) {
            this.writePkt();
        }
        return this.rawPkt;
    }

    protected void printPkt() {
        System.out.print("V:" + this.version + " P:" + this.padding + " EXT:" + this.extension);
        System.out.println(" CC:" + this.getCsrcCount() + " M:" + this.marker + " PT:" + this.payloadType + " SN: " + this.seqNumber);
        System.out.println("Timestamp:" + this.timeStamp + "(long output as int, may be 2s complement)");
        System.out.println("SSRC:" + this.ssrc + "(long output as int, may be 2s complement)");
        int i = 0;
        while (i < this.getCsrcCount()) {
            System.out.println("CSRC:" + this.csrcArray[i] + "(long output as int, may be 2s complement)");
            ++i;
        }
        System.out.println("Payload, first four bytes: " + this.payload[0] + " " + this.payload[1] + " " + this.payload[2] + " " + this.payload[3]);
    }

    protected void setMarked(boolean mark) {
        this.rawPktCurrent = false;
        this.marker = mark ? 1 : 0;
    }

    protected int setPayloadType(int plType) {
        int temp = plType & 0x7F;
        if (temp == plType) {
            this.rawPktCurrent = false;
            this.payloadType = temp;
            return 0;
        }
        return -1;
    }

    protected int setSeqNumber(int number) {
        if (number <= 65536 && number >= 0) {
            this.rawPktCurrent = false;
            this.seqNumber = number;
            return 0;
        }
        System.out.println("RtpPkt.setSeqNumber: invalid number");
        return -1;
    }

    protected int setTimeStamp(long time) {
        this.rawPktCurrent = false;
        this.timeStamp = time;
        return 0;
    }

    protected int setSsrc(long source) {
        this.rawPktCurrent = false;
        this.ssrc = source;
        return 0;
    }

    protected int setCsrcs(long[] contributors) {
        if (contributors.length <= 16) {
            this.csrcArray = contributors;
            return 0;
        }
        System.out.println("RtpPkt.setCsrcs: Cannot have more than 16 CSRCs");
        return -1;
    }

    protected int setPayload(byte[] data) {
        if (data.length < 1488) {
            this.rawPktCurrent = false;
            this.payload = data;
            return 0;
        }
        System.out.println("RtpPkt.setPayload: Cannot carry more than 1480 bytes for now.");
        return -1;
    }

    protected byte[] getPayload() {
        return this.payload;
    }

    private void writePkt() {
        int bytes = this.getPayloadLength();
        int headerLen = this.getHeaderLength();
        int csrcLen = this.getCsrcCount();
        this.rawPkt = new byte[headerLen + bytes];
        this.writeFirstLine();
        byte[] someBytes = StaticProcs.uIntLongToByteWord(this.timeStamp);
        int i = 0;
        while (i < 4) {
            this.rawPkt[i + 4] = someBytes[i];
            ++i;
        }
        someBytes = StaticProcs.uIntLongToByteWord(this.ssrc);
        System.arraycopy(someBytes, 0, this.rawPkt, 8, 4);
        i = 0;
        while (i < csrcLen) {
            someBytes = StaticProcs.uIntLongToByteWord(this.csrcArray[i]);
            System.arraycopy(someBytes, 0, this.rawPkt, 12 + 4 * i, 4);
            ++i;
        }
        System.arraycopy(this.payload, 0, this.rawPkt, headerLen, bytes);
        this.rawPktCurrent = true;
    }

    private void writeFirstLine() {
        int aByte = 0;
        aByte = (byte)(aByte | this.version << 6);
        aByte = (byte)(aByte | this.padding << 5);
        aByte = (byte)(aByte | this.extension << 4);
        this.rawPkt[0] = aByte = (int)((byte)(aByte | this.getCsrcCount()));
        aByte = 0;
        aByte = (byte)(aByte | this.marker << 7);
        this.rawPkt[1] = aByte = (int)((byte)(aByte | this.payloadType));
        byte[] someBytes = StaticProcs.uIntIntToByteWord(this.seqNumber);
        this.rawPkt[2] = someBytes[0];
        this.rawPkt[3] = someBytes[1];
    }

    private void sliceFirstLine() {
        this.version = (this.rawPkt[0] & 0xC0) >>> 6;
        this.padding = (this.rawPkt[0] & 0x20) >>> 5;
        this.extension = (this.rawPkt[0] & 0x10) >>> 4;
        this.csrcArray = new long[this.rawPkt[0] & 0xF];
        this.marker = (this.rawPkt[1] & 0x80) >> 7;
        this.payloadType = this.rawPkt[1] & 0x7F;
        this.seqNumber = StaticProcs.bytesToUIntInt(this.rawPkt, 2);
    }

    private void sliceTimeStamp() {
        this.timeStamp = StaticProcs.bytesToUIntLong(this.rawPkt, 4);
    }

    private void sliceSSRC() {
        this.ssrc = StaticProcs.bytesToUIntLong(this.rawPkt, 8);
    }

    private void sliceCSRCs() {
        int i = 0;
        while (i < this.csrcArray.length) {
            this.ssrc = StaticProcs.bytesToUIntLong(this.rawPkt, i * 4 + 12);
            ++i;
        }
    }

    private void slicePayload(int bytes) {
        this.payload = new byte[bytes];
        int headerLen = this.getHeaderLength();
        System.arraycopy(this.rawPkt, headerLen, this.payload, 0, bytes);
    }
}

