package com.beem.project.beem.ui;

import java.util.ArrayList;
import java.util.List;

import android.app.ListActivity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnKeyListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.BeemBroadcastReceiver;

/**
 * That activity permit to manage user groups.
 * @author nikita
 */
public class GroupList extends ListActivity {

    private static final Intent SERVICE_INTENT = new Intent();

    private final ServiceConnection mServConn = new BeemServiceConnection();
    private BeemBroadcastReceiver mReceiver;
    private IXmppFacade mXmppFacade;
    private IRoster mRoster;
    private String mJID;
    private ArrayAdapter<String> mGroups;
    private Contact mContact;
    private TextView mText;
    private final List<String> mStrings = new ArrayList<String>();

    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }

    /**
     * Constructor.
     */
    public GroupList() {
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.group_list);
	mReceiver = new BeemBroadcastReceiver(mServConn);
	mContact = getIntent().getParcelableExtra("contact");
	mJID = mContact.getJID();
	final ListView listView = getListView();

	listView.setItemsCanFocus(false);
	listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
	listView.setOnItemClickListener(new GroupOnItemClickListener());

	mText = (TextView) findViewById(R.id.GroupListText);
	mText.setOnKeyListener(new GroupListOnKeyListener());
        this.registerReceiver(mReceiver, new IntentFilter(BeemBroadcastReceiver.BEEM_CONNECTION_CLOSED));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onResume() {
	super.onResume();
	bindService(new Intent(this, BeemService.class), mServConn, BIND_AUTO_CREATE);
	mReceiver.setBinded(true);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onPause() {
	super.onPause();
	if (mReceiver.isBinded()) {
	    unbindService(mServConn);
	    mReceiver.setBinded(false);
	}
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(mReceiver);
    }

    /**
     * init activity list adapter.
     */
    private void setAdapter() {
	try {
	    for (String group : mRoster.getGroupsNames()) {
		mStrings.add(group);
	    }
	    mGroups = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_multiple_choice, mStrings);
	    setListAdapter(mGroups);
	    mContact = mRoster.getContact(mJID);
	    for (String group : mContact.getGroups()) {
		getListView().setItemChecked(mGroups.getPosition(group), true);
	    }
	} catch (RemoteException e) {
	    e.printStackTrace();
	}
    }

    /**
     * Event when group is added.
     */
    private class GroupListOnKeyListener implements OnKeyListener {

	/**
	 * Constructor.
	 */
	public GroupListOnKeyListener() {
	}

	@Override
	public boolean onKey(View v, int keyCode, KeyEvent event) {
	    boolean result = false;
	    if (event.getAction() == KeyEvent.ACTION_DOWN) {
		switch (keyCode) {
		    case KeyEvent.KEYCODE_DPAD_CENTER:
		    case KeyEvent.KEYCODE_ENTER:
			if (mText.getText().length() == 0)
			    return false;
			String groupname = mText.getText().toString();
			mGroups.add(groupname);
			mText.setText(null);
			result = true;
			break;
		    default:
			result = false;
		}
	    }
	    return result;
	}

    }

    /**
     * Event click on list group contact.
     */
    private class GroupOnItemClickListener implements OnItemClickListener {

	/**
	 * Constructor.
	 */
	public GroupOnItemClickListener() {
	}

	@Override
	public void onItemClick(AdapterView<?> arg0, View v, int arg2, long arg3) {
	    CheckedTextView textView = (CheckedTextView) v;
	    if (!textView.isChecked()) {
		try {
		    mRoster.addContactToGroup(textView.getText().toString(), mJID);
		} catch (RemoteException e) {
		    e.printStackTrace();
		}
	    } else {
		try {
		    mRoster.removeContactFromGroup(textView.getText().toString(), mJID);
		} catch (RemoteException e) {
		    e.printStackTrace();
		}
	    }

	}

    }

    /**
     * The ServiceConnection used to connect to the Beem service.
     */
    private class BeemServiceConnection implements ServiceConnection {

	/**
	 * Constructor.
	 */
	public BeemServiceConnection() {
	}

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	    mReceiver.setBinded(true);
	    try {
		mRoster = mXmppFacade.getRoster();
		setAdapter();
	    } catch (RemoteException e) {
		e.printStackTrace();
	    }
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    mXmppFacade = null;
	    mRoster = null;
	}
    }

}
