/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.jivesoftware.smackx.jingle.SmackLogger;

public class HttpServer {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(HttpServer.class);

    public HttpServer(int n) {
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            LOGGER.debug("httpServer running on port " + serverSocket.getLocalPort());
            while (true) {
                Socket socket = serverSocket.accept();
                LOGGER.debug("New connection accepted " + socket.getInetAddress() + ":" + socket.getPort());
                try {
                    HttpRequestHandler httpRequestHandler = new HttpRequestHandler(socket);
                    Thread thread = new Thread(httpRequestHandler);
                    thread.start();
                }
                catch (Exception exception) {
                    LOGGER.debug("", exception);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.debug("", iOException);
            return;
        }
    }

    public static void main(String[] stringArray) {
        HttpServer httpServer = new HttpServer(Integer.parseInt(stringArray[0]));
    }

    class HttpRequestHandler
    implements Runnable {
        static final String CRLF = "\r\n";
        Socket socket;
        InputStream input;
        OutputStream output;
        BufferedReader br;

        public HttpRequestHandler(Socket socket) throws Exception {
            this.socket = socket;
            this.input = socket.getInputStream();
            this.output = socket.getOutputStream();
            this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        public void run() {
            try {
                this.processRequest();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void processRequest() throws Exception {
            while (true) {
                String string = this.br.readLine();
                LOGGER.debug(string);
                if (string.equals(CRLF) || string.equals("")) break;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (!string2.equals("GET")) continue;
                String string3 = "Server: Simple httpServer";
                String string4 = "text";
                String string5 = "";
                String string6 = "HTTP/1.0 200 OK\r\n";
                String string7 = "Content-Length: " + new Integer(string5.length()).toString() + CRLF;
                string4 = "text/html";
                this.output.write(string6.getBytes());
                this.output.write(string3.getBytes());
                this.output.write(string4.getBytes());
                this.output.write(string7.getBytes());
                this.output.write(CRLF.getBytes());
                this.output.write(string5.getBytes());
            }
            try {
                this.output.close();
                this.br.close();
                this.socket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

