/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.Hashtable;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.packet.DefaultPrivateData;
import org.jivesoftware.smackx.packet.PrivateData;
import org.jivesoftware.smackx.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;

public class PrivateDataManager {
    private static Map privateDataProviders = new Hashtable();
    private Connection connection;
    private String user;

    public static PrivateDataProvider getPrivateDataProvider(String string, String string2) {
        String string3 = PrivateDataManager.getProviderKey(string, string2);
        return (PrivateDataProvider)privateDataProviders.get(string3);
    }

    public static void addPrivateDataProvider(String string, String string2, PrivateDataProvider privateDataProvider) {
        String string3 = PrivateDataManager.getProviderKey(string, string2);
        privateDataProviders.put(string3, privateDataProvider);
    }

    public static void removePrivateDataProvider(String string, String string2) {
        String string3 = PrivateDataManager.getProviderKey(string, string2);
        privateDataProviders.remove(string3);
    }

    public PrivateDataManager(Connection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to XMPP server.");
        }
        this.connection = connection;
    }

    public PrivateDataManager(Connection connection, String string) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to XMPP server.");
        }
        this.connection = connection;
        this.user = string;
    }

    public PrivateData getPrivateData(final String string, final String string2) throws XMPPException {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<query xmlns=\"jabber:iq:private\">");
                stringBuilder.append("<").append(string).append(" xmlns=\"").append(string2).append("\"/>");
                stringBuilder.append("</query>");
                return stringBuilder.toString();
            }
        };
        iQ.setType(IQ.Type.GET);
        if (this.user != null) {
            iQ.setTo(this.user);
        }
        String string3 = iQ.getPacketID();
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(string3));
        this.connection.sendPacket(iQ);
        IQ iQ2 = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ2 == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ2.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ2.getError());
        }
        return ((PrivateDataResult)iQ2).getPrivateData();
    }

    public void setPrivateData(final PrivateData privateData) throws XMPPException {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<query xmlns=\"jabber:iq:private\">");
                stringBuilder.append(privateData.toXML());
                stringBuilder.append("</query>");
                return stringBuilder.toString();
            }
        };
        iQ.setType(IQ.Type.SET);
        if (this.user != null) {
            iQ.setTo(this.user);
        }
        String string = iQ.getPacketID();
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(string));
        this.connection.sendPacket(iQ);
        IQ iQ2 = (IQ)packetCollector.nextResult(5000L);
        packetCollector.cancel();
        if (iQ2 == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ2.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ2.getError());
        }
    }

    private static String getProviderKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string).append("/><").append(string2).append("/>");
        return stringBuilder.toString();
    }

    private static class PrivateDataResult
    extends IQ {
        private PrivateData privateData;

        PrivateDataResult(PrivateData privateData) {
            this.privateData = privateData;
        }

        public PrivateData getPrivateData() {
            return this.privateData;
        }

        @Override
        public String getChildElementXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<query xmlns=\"jabber:iq:private\">");
            if (this.privateData != null) {
                this.privateData.toXML();
            }
            stringBuilder.append("</query>");
            return stringBuilder.toString();
        }
    }

    public static class PrivateDataIQProvider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            PrivateData privateData = null;
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    String string;
                    String string2 = xmlPullParser.getName();
                    PrivateDataProvider privateDataProvider = PrivateDataManager.getPrivateDataProvider(string2, string = xmlPullParser.getNamespace());
                    if (privateDataProvider != null) {
                        privateData = privateDataProvider.parsePrivateData(xmlPullParser);
                        continue;
                    }
                    DefaultPrivateData defaultPrivateData = new DefaultPrivateData(string2, string);
                    boolean bl2 = false;
                    while (!bl2) {
                        int n2 = xmlPullParser.next();
                        if (n2 == 2) {
                            String string3 = xmlPullParser.getName();
                            if (xmlPullParser.isEmptyElementTag()) {
                                defaultPrivateData.setValue(string3, "");
                                continue;
                            }
                            n2 = xmlPullParser.next();
                            if (n2 != 4) continue;
                            String string4 = xmlPullParser.getText();
                            defaultPrivateData.setValue(string3, string4);
                            continue;
                        }
                        if (n2 != 3 || !xmlPullParser.getName().equals(string2)) continue;
                        bl2 = true;
                    }
                    privateData = defaultPrivateData;
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
                bl = true;
            }
            return new PrivateDataResult(privateData);
        }
    }
}

