/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.util;

import de.javawi.jstun.util.Utility;
import de.javawi.jstun.util.UtilityException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Address {
    int firstOctet;
    int secondOctet;
    int thirdOctet;
    int fourthOctet;

    public Address(int firstOctet, int secondOctet, int thirdOctet, int fourthOctet) throws UtilityException {
        if (firstOctet < 0 || firstOctet > 255 || secondOctet < 0 || secondOctet > 255 || thirdOctet < 0 || thirdOctet > 255 || fourthOctet < 0 || fourthOctet > 255) {
            throw new UtilityException("Address is malformed.");
        }
        this.firstOctet = firstOctet;
        this.secondOctet = secondOctet;
        this.thirdOctet = thirdOctet;
        this.fourthOctet = fourthOctet;
    }

    public Address(String address) throws UtilityException {
        StringTokenizer st = new StringTokenizer(address, ".");
        if (st.countTokens() != 4) {
            throw new UtilityException("4 octets in address string are required.");
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            int temp = Integer.parseInt(st.nextToken());
            if (temp < 0 || temp > 255) {
                throw new UtilityException("Address is in incorrect format.");
            }
            switch (i) {
                case 0: {
                    this.firstOctet = temp;
                    ++i;
                    break;
                }
                case 1: {
                    this.secondOctet = temp;
                    ++i;
                    break;
                }
                case 2: {
                    this.thirdOctet = temp;
                    ++i;
                    break;
                }
                case 3: {
                    this.fourthOctet = temp;
                    ++i;
                }
            }
        }
    }

    public Address(byte[] address) throws UtilityException {
        if (address.length < 4) {
            throw new UtilityException("4 bytes are required.");
        }
        this.firstOctet = Utility.oneByteToInteger(address[0]);
        this.secondOctet = Utility.oneByteToInteger(address[1]);
        this.thirdOctet = Utility.oneByteToInteger(address[2]);
        this.fourthOctet = Utility.oneByteToInteger(address[3]);
    }

    public String toString() {
        return this.firstOctet + "." + this.secondOctet + "." + this.thirdOctet + "." + this.fourthOctet;
    }

    public byte[] getBytes() throws UtilityException {
        byte[] result = new byte[]{Utility.integerToOneByte(this.firstOctet), Utility.integerToOneByte(this.secondOctet), Utility.integerToOneByte(this.thirdOctet), Utility.integerToOneByte(this.fourthOctet)};
        return result;
    }

    public InetAddress getInetAddress() throws UtilityException, UnknownHostException {
        byte[] address = new byte[]{Utility.integerToOneByte(this.firstOctet), Utility.integerToOneByte(this.secondOctet), Utility.integerToOneByte(this.thirdOctet), Utility.integerToOneByte(this.fourthOctet)};
        return InetAddress.getByAddress(address);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            byte[] data1 = this.getBytes();
            byte[] data2 = ((Address)obj).getBytes();
            return data1[0] == data2[0] && data1[1] == data2[1] && data1[2] == data2[2] && data1[3] == data2[3];
        }
        catch (UtilityException ue) {
            return false;
        }
    }

    public int hashCode() {
        return (this.firstOctet << 24) + (this.secondOctet << 16) + (this.thirdOctet << 8) + this.fourthOctet;
    }
}

