/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.packet.Jingle;

public class JingleSessionRequest {
    private final Jingle jingle;
    private final JingleManager manager;

    public JingleSessionRequest(JingleManager manager, Jingle jingle) {
        this.manager = manager;
        this.jingle = jingle;
    }

    public String getFrom() {
        return this.jingle.getFrom();
    }

    public String getSessionID() {
        return this.jingle.getSid();
    }

    public Jingle getJingle() {
        return this.jingle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JingleSession accept() throws XMPPException {
        JingleSession session = null;
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            session = this.manager.createIncomingJingleSession(this);
            session.setSid(this.getSessionID());
            session.updatePacketListener();
            session.receivePacketAndRespond(this.getJingle());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reject() {
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            this.manager.rejectIncomingJingleSession(this);
        }
    }
}

