/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;

public class XMPPException
extends Exception {
    private StreamError streamError = null;
    private XMPPError error = null;
    private Throwable wrappedThrowable = null;

    public XMPPException() {
    }

    public XMPPException(String string) {
        super(string);
    }

    public XMPPException(Throwable throwable) {
        this.wrappedThrowable = throwable;
    }

    public XMPPException(StreamError streamError) {
        this.streamError = streamError;
    }

    public XMPPException(XMPPError xMPPError) {
        this.error = xMPPError;
    }

    public XMPPException(String string, Throwable throwable) {
        super(string);
        this.wrappedThrowable = throwable;
    }

    public XMPPException(String string, XMPPError xMPPError, Throwable throwable) {
        super(string);
        this.error = xMPPError;
        this.wrappedThrowable = throwable;
    }

    public XMPPException(String string, XMPPError xMPPError) {
        super(string);
        this.error = xMPPError;
    }

    public XMPPError getXMPPError() {
        return this.error;
    }

    public StreamError getStreamError() {
        return this.streamError;
    }

    public Throwable getWrappedThrowable() {
        return this.wrappedThrowable;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.wrappedThrowable != null) {
            printStream.println("Nested Exception: ");
            this.wrappedThrowable.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.wrappedThrowable != null) {
            printWriter.println("Nested Exception: ");
            this.wrappedThrowable.printStackTrace(printWriter);
        }
    }

    public String getMessage() {
        String string = super.getMessage();
        if (string == null && this.error != null) {
            return this.error.toString();
        }
        if (string == null && this.streamError != null) {
            return this.streamError.toString();
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = super.getMessage();
        if (string != null) {
            stringBuilder.append(string).append(": ");
        }
        if (this.error != null) {
            stringBuilder.append(this.error);
        }
        if (this.streamError != null) {
            stringBuilder.append(this.streamError);
        }
        if (this.wrappedThrowable != null) {
            stringBuilder.append("\n  -- caused by: ").append(this.wrappedThrowable);
        }
        return stringBuilder.toString();
    }
}

