/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PrivacyList;
import org.jivesoftware.smack.PrivacyListListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Privacy;
import org.jivesoftware.smack.packet.PrivacyItem;

public class PrivacyListManager {
    private static Map<Connection, PrivacyListManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private Connection connection;
    private final List<PrivacyListListener> listeners = new ArrayList<PrivacyListListener>();
    PacketFilter packetFilter = new AndFilter(new IQTypeFilter(IQ.Type.SET), new PacketExtensionFilter("query", "jabber:iq:privacy"));

    private PrivacyListManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    private String getUser() {
        return this.connection.getUser();
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                instances.remove(PrivacyListManager.this.connection);
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
            }

            @Override
            public void reconnectionFailed(Exception exception) {
            }

            @Override
            public void reconnectingIn(int n) {
            }

            @Override
            public void reconnectionSuccessful() {
            }
        });
        this.connection.addPacketListener(new PacketListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processPacket(Packet packet) {
                if (packet == null || packet.getError() != null) {
                    return;
                }
                Privacy privacy = (Privacy)packet;
                Object object = PrivacyListManager.this.listeners;
                synchronized (object) {
                    for (PrivacyListListener privacyListListener : PrivacyListManager.this.listeners) {
                        for (Map.Entry<String, List<PrivacyItem>> entry : privacy.getItemLists().entrySet()) {
                            String string = entry.getKey();
                            List<PrivacyItem> list = entry.getValue();
                            if (list.isEmpty()) {
                                privacyListListener.updatedPrivacyList(string);
                                continue;
                            }
                            privacyListListener.setPrivacyList(string, list);
                        }
                    }
                }
                object = new IQ(){

                    @Override
                    public String getChildElementXML() {
                        return "";
                    }
                };
                ((IQ)object).setType(IQ.Type.RESULT);
                ((Packet)object).setFrom(packet.getFrom());
                ((Packet)object).setPacketID(packet.getPacketID());
                PrivacyListManager.this.connection.sendPacket((Packet)object);
            }
        }, this.packetFilter);
    }

    public static PrivacyListManager getInstanceFor(Connection connection) {
        return instances.get(connection);
    }

    private Privacy getRequest(Privacy privacy) throws XMPPException {
        privacy.setType(IQ.Type.GET);
        privacy.setFrom(this.getUser());
        PacketIDFilter packetIDFilter = new PacketIDFilter(privacy.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(privacy);
        Privacy privacy2 = (Privacy)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (privacy2 == null) {
            throw new XMPPException("No response from server.");
        }
        if (privacy2.getError() != null) {
            throw new XMPPException(privacy2.getError());
        }
        return privacy2;
    }

    private Packet setRequest(Privacy privacy) throws XMPPException {
        privacy.setType(IQ.Type.SET);
        privacy.setFrom(this.getUser());
        PacketIDFilter packetIDFilter = new PacketIDFilter(privacy.getPacketID());
        PacketCollector packetCollector = this.connection.createPacketCollector(packetIDFilter);
        this.connection.sendPacket(privacy);
        Packet packet = packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (packet == null) {
            throw new XMPPException("No response from server.");
        }
        if (packet.getError() != null) {
            throw new XMPPException(packet.getError());
        }
        return packet;
    }

    private Privacy getPrivacyWithListNames() throws XMPPException {
        Privacy privacy = new Privacy();
        return this.getRequest(privacy);
    }

    public PrivacyList getActiveList() throws XMPPException {
        Privacy privacy = this.getPrivacyWithListNames();
        String string = privacy.getActiveName();
        boolean bl = privacy.getActiveName() != null && privacy.getDefaultName() != null && privacy.getActiveName().equals(privacy.getDefaultName());
        return new PrivacyList(true, bl, string, this.getPrivacyListItems(string));
    }

    public PrivacyList getDefaultList() throws XMPPException {
        Privacy privacy = this.getPrivacyWithListNames();
        String string = privacy.getDefaultName();
        boolean bl = privacy.getActiveName() != null && privacy.getDefaultName() != null && privacy.getActiveName().equals(privacy.getDefaultName());
        return new PrivacyList(bl, true, string, this.getPrivacyListItems(string));
    }

    private List<PrivacyItem> getPrivacyListItems(String string) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, new ArrayList<PrivacyItem>());
        Privacy privacy2 = this.getRequest(privacy);
        return privacy2.getPrivacyList(string);
    }

    public PrivacyList getPrivacyList(String string) throws XMPPException {
        return new PrivacyList(false, false, string, this.getPrivacyListItems(string));
    }

    public PrivacyList[] getPrivacyLists() throws XMPPException {
        Privacy privacy = this.getPrivacyWithListNames();
        Set<String> set = privacy.getPrivacyListNames();
        PrivacyList[] privacyListArray = new PrivacyList[set.size()];
        int n = 0;
        for (String string : set) {
            boolean bl = string.equals(privacy.getActiveName());
            boolean bl2 = string.equals(privacy.getDefaultName());
            privacyListArray[n] = new PrivacyList(bl, bl2, string, this.getPrivacyListItems(string));
            ++n;
        }
        return privacyListArray;
    }

    public void setActiveListName(String string) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setActiveName(string);
        this.setRequest(privacy);
    }

    public void declineActiveList() throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setDeclineActiveList(true);
        this.setRequest(privacy);
    }

    public void setDefaultListName(String string) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setDefaultName(string);
        this.setRequest(privacy);
    }

    public void declineDefaultList() throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setDeclineDefaultList(true);
        this.setRequest(privacy);
    }

    public void createPrivacyList(String string, List<PrivacyItem> list) throws XMPPException {
        this.updatePrivacyList(string, list);
    }

    public void updatePrivacyList(String string, List<PrivacyItem> list) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, list);
        this.setRequest(privacy);
    }

    public void deletePrivacyList(String string) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string, new ArrayList<PrivacyItem>());
        this.setRequest(privacy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PrivacyListListener privacyListListener) {
        List<PrivacyListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(privacyListListener);
        }
    }

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new PrivacyListManager(connection);
            }
        });
    }
}

