/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import org.jlibrtp.jlibrtp.core.RTPSession;
import org.jlibrtp.jlibrtp.core.RtcpPkt;
import org.jlibrtp.jlibrtp.core.StaticProcs;

public class RtcpPktPSFB
extends RtcpPkt {
    protected boolean notRelevant = false;
    private RTPSession rtpSession;
    protected long ssrcMediaSource = -1L;
    protected int[] sliFirst;
    protected int[] sliNumber;
    protected int[] sliPictureId;
    protected int rpsiPadding = -1;
    protected int rpsiPayloadType = -1;
    protected byte[] rpsiBitString;
    protected byte[] alfBitString;

    protected RtcpPktPSFB(long ssrcPacketSender, long ssrcMediaSource) {
        this.ssrc = ssrcPacketSender;
        this.ssrcMediaSource = ssrcMediaSource;
        this.packetType = 206;
    }

    protected void makePictureLossIndication() {
        this.itemCount = 1;
    }

    protected void makeSliceLossIndication(int[] sliFirst, int[] sliNumber, int[] sliPictureId) {
        this.itemCount = 2;
        this.sliFirst = sliFirst;
        this.sliNumber = sliNumber;
        this.sliPictureId = sliPictureId;
    }

    protected void makeRefPictureSelIndic(int bitPadding, int payloadType, byte[] bitString) {
        this.itemCount = 3;
        this.rpsiPadding = bitPadding;
        this.rpsiPayloadType = payloadType;
        this.rpsiBitString = bitString;
    }

    protected void makeAppLayerFeedback(byte[] bitString) {
        this.itemCount = 15;
        this.alfBitString = bitString;
    }

    protected RtcpPktPSFB(byte[] aRawPkt, int start, RTPSession rtpSession) {
        this.rtpSession = rtpSession;
        this.rawPkt = aRawPkt;
        if (!super.parseHeaders(start) || this.packetType != 206 || this.length < 2) {
            this.problem = -206;
        } else {
            this.ssrcMediaSource = StaticProcs.bytesToUIntLong(aRawPkt, 8 + start);
            if (this.ssrcMediaSource == rtpSession.ssrc) {
                this.ssrc = StaticProcs.bytesToUIntLong(aRawPkt, 4 + start);
                switch (this.itemCount) {
                    case 1: {
                        this.decPictureLossIndic();
                        break;
                    }
                    case 2: {
                        this.decSliceLossIndic(aRawPkt, start + 12);
                        break;
                    }
                    case 3: {
                        this.decRefPictureSelIndic(aRawPkt, start + 12);
                        break;
                    }
                    case 15: {
                        this.decAppLayerFB(aRawPkt, start + 12);
                        break;
                    }
                    default: {
                        System.out.println("!!!! RtcpPktPSFB(byte[], int start) unexpected FMT " + this.itemCount);
                        break;
                    }
                }
            } else {
                this.notRelevant = true;
            }
        }
    }

    private void decPictureLossIndic() {
        if (this.rtpSession.rtcpAVPFIntf != null) {
            this.rtpSession.rtcpAVPFIntf.PSFBPktPictureLossReceived(this.ssrc);
        }
    }

    private void decSliceLossIndic(byte[] aRawPkt, int start) {
        int count = this.length - 2;
        this.sliFirst = new int[count];
        this.sliNumber = new int[count];
        this.sliPictureId = new int[count];
        int i = 0;
        while (i < count) {
            this.sliFirst[i] = StaticProcs.bytesToUIntInt(aRawPkt, start) >> 3;
            this.sliNumber[i] = (StaticProcs.bytesToUIntInt(aRawPkt, start) & 0x7FFC0) >> 6;
            this.sliPictureId[i] = StaticProcs.bytesToUIntInt(aRawPkt, start + 2) & 0x3F;
            start += 4;
            ++i;
        }
        if (this.rtpSession.rtcpAVPFIntf != null) {
            this.rtpSession.rtcpAVPFIntf.PSFBPktSliceLossIndic(this.ssrc, this.sliFirst, this.sliNumber, this.sliPictureId);
        }
    }

    private void decRefPictureSelIndic(byte[] aRawPkt, int start) {
        this.rpsiPadding = aRawPkt[start];
        if (this.rpsiPadding > 32) {
            System.out.println("!!!! RtcpPktPSFB.decRefPictureSelcIndic paddingBits: " + this.rpsiPadding);
        }
        this.rpsiPayloadType = this.rawPkt[start];
        if (this.rpsiPayloadType < 0) {
            System.out.println("!!!! RtcpPktPSFB.decRefPictureSelcIndic 8th bit not zero: " + this.rpsiPayloadType);
        }
        this.rpsiBitString = new byte[(this.length - 2) * 4 - 2];
        System.arraycopy(aRawPkt, start + 2, this.rpsiBitString, 0, this.rpsiBitString.length);
        if (this.rtpSession.rtcpAVPFIntf != null) {
            this.rtpSession.rtcpAVPFIntf.PSFBPktRefPictureSelIndic(this.ssrc, this.rpsiPayloadType, this.rpsiBitString, this.rpsiPadding);
        }
    }

    private void decAppLayerFB(byte[] aRawPkt, int start) {
        int stringLength = (this.length - 2) * 4;
        this.alfBitString = new byte[stringLength];
        System.arraycopy(aRawPkt, start, this.alfBitString, 0, stringLength);
        if (this.rtpSession.rtcpAVPFIntf != null) {
            this.rtpSession.rtcpAVPFIntf.PSFBPktAppLayerFBReceived(this.ssrc, this.alfBitString);
        }
    }

    private void encSliceLossIndic() {
        int offset = 8;
        int i = 0;
        while (i < this.sliFirst.length) {
            offset = 8 + 8 * i;
            byte[] firstBytes = StaticProcs.uIntLongToByteWord(this.sliFirst[i] << 3);
            byte[] numbBytes = StaticProcs.uIntLongToByteWord(this.sliNumber[i] << 2);
            byte[] picBytes = StaticProcs.uIntIntToByteWord(this.sliPictureId[i]);
            this.rawPkt[offset] = firstBytes[2];
            this.rawPkt[offset + 1] = (byte)(firstBytes[3] | numbBytes[2]);
            this.rawPkt[offset + 2] = numbBytes[3];
            this.rawPkt[offset + 3] = (byte)(numbBytes[3] | picBytes[1]);
            ++i;
        }
    }

    private void encRefPictureSelIndic() {
        byte[] someBytes = StaticProcs.uIntIntToByteWord(this.rpsiPadding);
        this.rawPkt[8] = someBytes[1];
        someBytes = StaticProcs.uIntIntToByteWord(this.rpsiPayloadType);
        this.rawPkt[9] = someBytes[1];
        System.arraycopy(this.rpsiBitString, 0, this.rawPkt, 10, this.rpsiBitString.length);
    }

    private void encAppLayerFB() {
        System.arraycopy(this.alfBitString, 0, this.rawPkt, 8, this.alfBitString.length);
    }

    protected int getFMT() {
        return this.itemCount;
    }

    @Override
    protected void encode() {
        switch (this.itemCount) {
            case 1: {
                this.rawPkt = new byte[24];
                break;
            }
            case 2: {
                this.rawPkt = new byte[24 + 4 * this.sliFirst.length];
                this.encSliceLossIndic();
                break;
            }
            case 3: {
                this.rawPkt = new byte[26 + this.rpsiBitString.length / 4];
                this.encRefPictureSelIndic();
                break;
            }
            case 15: {
                this.rawPkt = new byte[24 + this.alfBitString.length / 4];
                this.encAppLayerFB();
            }
        }
        byte[] someBytes = StaticProcs.uIntLongToByteWord(this.ssrc);
        System.arraycopy(someBytes, 0, this.rawPkt, 4, 4);
        someBytes = StaticProcs.uIntLongToByteWord(this.ssrcMediaSource);
        System.arraycopy(someBytes, 0, this.rawPkt, 8, 4);
        this.writeHeaders();
    }

    public void debugPrint() {
        System.out.println("->RtcpPktPSFB.debugPrint() ");
        switch (this.itemCount) {
            case 1: {
                System.out.println("  FMT: Picture Loss Indication");
                break;
            }
            case 2: {
                String str = this.sliFirst != null ? "sliFirst[].length: " + this.sliFirst.length : "sliFirst[] is null";
                System.out.println("  FMT: Slice Loss Indication, " + str);
                break;
            }
            case 3: {
                String str = this.rpsiBitString != null ? "rpsiBitString[].length: " + this.rpsiBitString.length : "rpsiBitString[] is null";
                System.out.println("  FMT: Reference Picture Selection Indication, " + str + " payloadType: " + this.rpsiPayloadType);
                break;
            }
            case 15: {
                String str = this.alfBitString != null ? "alfBitString[].length: " + this.alfBitString.length : "alfBitString[] is null";
                System.out.println("  FMT: Application Layer Feedback Messages, " + str);
            }
        }
        System.out.println("<-RtcpPktPSFB.debugPrint() ");
    }
}

