package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

import com.beem.project.beem.R;

public class ContactListSettings extends Activity {

    public static final int CHANGE = 1;
    private boolean mIsChanged = false;
    private SharedPreferences mSettings;
    private String[] mProxyTypeString;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.contactlistsettings);

	String TypeNone = getString(R.string.PreferenceProxyTypeNone);
	String TypeHTTP = getString(R.string.PreferenceProxyTypeHttp);
	String TypeSocks4 = getString(R.string.PreferenceProxyTypeSocks4);
	String TypeSocks5 = getString(R.string.PreferenceProxyTypeSocks5);

	mProxyTypeString = new String[] { TypeNone, TypeHTTP, TypeSocks4, TypeSocks5 };
	mSettings = getSharedPreferences(getString(R.string.PreferenceFileName), MODE_PRIVATE);

	Spinner sp = (Spinner) findViewById(R.id.proxy_type);
	ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item,
	    mProxyTypeString);
	adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
	sp.setAdapter(adapter);
	for (int i = 0; i < mProxyTypeString.length; ++i)
	    if (mProxyTypeString[i].equals(getPreferenceString(R.string.PreferenceProxyType)))
		sp.setSelection(i);
	sp.setOnItemSelectedListener(mProxyType);

	showSettings();
	Button ok = (Button) findViewById(R.id.ok);
	ok.setOnClickListener(mOkListener);
	
	Button reco = (Button) findViewById(R.id.reconnect);
	reco.setOnClickListener(new OnClickListener () {

	    @Override
	    public void onClick(View v) {
		setResult(RESULT_OK);
		finish();
	    }
	    
	});
    }

    private OnItemSelectedListener mProxyType = new OnItemSelectedListener() {

	@Override
	public void onItemSelected(AdapterView<?> parent, View arg1, int arg2, long arg3) {
	    String value = parent.getSelectedItem().toString();
	    LinearLayout ll = (LinearLayout) findViewById(R.id.proxy_layout);
	    SharedPreferences.Editor editor = mSettings.edit();

	    if (value.equals(getString(R.string.PreferenceProxyTypeNone))) {
		ll.setVisibility(LinearLayout.INVISIBLE);
		editor.putBoolean(getString(R.string.PreferenceUseProxy), false);
	    } else {
		ll.setVisibility(LinearLayout.VISIBLE);
		editor.putBoolean(getString(R.string.PreferenceUseProxy), true);
	    }
	    if (!value.equals(getPreferenceString(R.string.PreferenceProxyType))) {
		editor.putString(getString(R.string.PreferenceProxyType), value);
		mIsChanged = true;
	    }
	    editor.commit();
	}

	@Override
	public void onNothingSelected(AdapterView<?> arg0) {
	}

    };

    private OnClickListener mOkListener = new OnClickListener() {
	public void onClick(View v) {
	    SharedPreferences.Editor editor = mSettings.edit();
	    
	    if (isChanged(R.id.host, R.string.PreferenceHostKey)) {
		editor.putString(getString(R.string.PreferenceHostKey), getWidgetText(R.id.host));
		mIsChanged = true;
	    }
	    if (Integer.parseInt(getWidgetText(R.id.port)) != mSettings.getInt(getString(R.string.PreferencePortKey), 5222) ) {
		editor.putInt(getString(R.string.PreferencePortKey), Integer.parseInt(getWidgetText(R.id.port)));
		mIsChanged = true;
	    }
	    if (isChanged(R.id.userid, R.string.PreferenceLoginKey)) {
		editor.putString(getString(R.string.PreferenceLoginKey), getWidgetText(R.id.userid));
		mIsChanged = true;
	    }
	    if (isChanged(R.id.password, R.string.PreferencePasswordKey)) {
		editor.putString(getString(R.string.PreferencePasswordKey), getWidgetText(R.id.password));
		mIsChanged = true;
	    }

	    if (isChanged(R.id.proxy_host, R.string.PreferenceProxyHost)) {
		editor.putString(getString(R.string.PreferenceProxyHost), getWidgetText(R.id.proxy_host));
		mIsChanged = true;
	    }
	    if (Integer.parseInt(getWidgetText(R.id.proxy_port)) != mSettings.getInt(getString(R.string.PreferenceProxyPort), 1080) ) {
		editor.putInt(getString(R.string.PreferenceProxyPort), Integer.parseInt(getWidgetText(R.id.proxy_port)));
		mIsChanged = true;
	    }
	    if (isChanged(R.id.proxy_login, R.string.PreferenceProxyUser)) {
		editor.putString(getString(R.string.PreferenceProxyUser), getWidgetText(R.id.proxy_login));
		mIsChanged = true;
	    }
	    if (isChanged(R.id.proxy_pwd, R.string.PreferenceProxyPassword)) {
		editor.putString(getString(R.string.PreferenceProxyPassword), getWidgetText(R.id.proxy_pwd));
		mIsChanged = true;
	    }

	    if (mIsChanged == true) {
		editor.commit();
		setResult(RESULT_OK);
	    } else
		setResult(RESULT_CANCELED);
	    finish();
	}
    };

    private boolean isChanged(int idEdit, int idPreference) {
	return (!getWidgetText(idEdit).equals(getPreferenceString(idPreference)));
    }

    private void showSettings() {
	EditText e = (EditText) findViewById(R.id.host);
	e.setText(getPreferenceString(R.string.PreferenceHostKey));
	e = (EditText) findViewById(R.id.port);
	e.setText(String.valueOf(mSettings.getInt(getString(R.string.PreferencePortKey), 1080)));
	e = (EditText) findViewById(R.id.userid);
	e.setText(getPreferenceString(R.string.PreferenceLoginKey));
	e = (EditText) findViewById(R.id.password);
	e.setText(getPreferenceString(R.string.PreferencePasswordKey));

	e = (EditText) findViewById(R.id.proxy_host);
	e.setText(getPreferenceString(R.string.PreferenceProxyHost));
	e = (EditText) findViewById(R.id.proxy_port);
	e.setText(String.valueOf(mSettings.getInt(getString(R.string.PreferenceProxyPort), 1080)));
	e = (EditText) findViewById(R.id.proxy_login);
	e.setText(getPreferenceString(R.string.PreferenceProxyUser));
	e = (EditText) findViewById(R.id.proxy_pwd);
	e.setText(getPreferenceString(R.string.PreferenceProxyPassword));
    }

    private String getWidgetText(int id) {
	EditText widget = (EditText) this.findViewById(id);
	return widget.getText().toString();
    }

    private String getPreferenceString(int id) {
	return mSettings.getString(getString(id), "");
    }

}
