/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.macros;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smackx.workgroup.ext.macros.Macro;

public class MacroGroup {
    private List<Macro> macros = new ArrayList<Macro>();
    private List<MacroGroup> macroGroups = new ArrayList<MacroGroup>();
    private String title;

    public void addMacro(Macro macro) {
        this.macros.add(macro);
    }

    public void removeMacro(Macro macro) {
        this.macros.remove(macro);
    }

    public Macro getMacroByTitle(String string) {
        List<Macro> list = Collections.unmodifiableList(this.macros);
        for (Macro macro : list) {
            if (!macro.getTitle().equalsIgnoreCase(string)) continue;
            return macro;
        }
        return null;
    }

    public void addMacroGroup(MacroGroup macroGroup) {
        this.macroGroups.add(macroGroup);
    }

    public void removeMacroGroup(MacroGroup macroGroup) {
        this.macroGroups.remove(macroGroup);
    }

    public Macro getMacro(int n) {
        return this.macros.get(n);
    }

    public MacroGroup getMacroGroupByTitle(String string) {
        List<MacroGroup> list = Collections.unmodifiableList(this.macroGroups);
        for (MacroGroup macroGroup : list) {
            if (!macroGroup.getTitle().equalsIgnoreCase(string)) continue;
            return macroGroup;
        }
        return null;
    }

    public MacroGroup getMacroGroup(int n) {
        return this.macroGroups.get(n);
    }

    public List<Macro> getMacros() {
        return this.macros;
    }

    public void setMacros(List<Macro> list) {
        this.macros = list;
    }

    public List<MacroGroup> getMacroGroups() {
        return this.macroGroups;
    }

    public void setMacroGroups(List<MacroGroup> list) {
        this.macroGroups = list;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<macrogroup>");
        stringBuilder.append("<title>" + this.getTitle() + "</title>");
        stringBuilder.append("<macros>");
        for (Macro object : this.getMacros()) {
            stringBuilder.append("<macro>");
            stringBuilder.append("<title>" + object.getTitle() + "</title>");
            stringBuilder.append("<type>" + object.getType() + "</type>");
            stringBuilder.append("<description>" + object.getDescription() + "</description>");
            stringBuilder.append("<response>" + object.getResponse() + "</response>");
            stringBuilder.append("</macro>");
        }
        stringBuilder.append("</macros>");
        if (this.getMacroGroups().size() > 0) {
            stringBuilder.append("<macroGroups>");
            for (MacroGroup macroGroup : this.getMacroGroups()) {
                stringBuilder.append(macroGroup.toXML());
            }
            stringBuilder.append("</macroGroups>");
        }
        stringBuilder.append("</macrogroup>");
        return stringBuilder.toString();
    }
}

