/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.jingle.ContentNegotiator;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleException;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.JingleSessionState;
import org.jivesoftware.smackx.jingle.JingleSessionStateActive;
import org.jivesoftware.smackx.jingle.JingleSessionStateEnded;
import org.jivesoftware.smackx.jingle.JingleSessionStatePending;
import org.jivesoftware.smackx.jingle.JingleSessionStateUnknown;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.MediaReceivedListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleSession
extends JingleNegotiator
implements MediaReceivedListener {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleSession.class);
    private static final HashMap sessions = new HashMap();
    private static final Random randomGenerator = new Random();
    private String initiator;
    private String responder;
    private String sid;
    ConnectionListener connectionListener;
    PacketListener packetListener;
    PacketFilter packetFilter;
    protected List<JingleMediaManager> jingleMediaManagers = null;
    private boolean closed = false;
    private JingleSessionState sessionState;
    private List<ContentNegotiator> contentNegotiators;
    private JingleSessionRequest sessionRequest;
    private XMPPConnection connection;
    private String sessionInitPacketID;
    private Map<String, JingleMediaSession> mediaSessionMap;

    public JingleSession(XMPPConnection conn, String initiator, String responder, String sessionid, List<JingleMediaManager> jingleMediaManagers) {
        this.initiator = initiator;
        this.responder = responder;
        this.sid = sessionid;
        this.jingleMediaManagers = jingleMediaManagers;
        this.setSession(this);
        this.connection = conn;
        this.setSessionState(JingleSessionStateUnknown.getInstance());
        this.contentNegotiators = new ArrayList<ContentNegotiator>();
        this.mediaSessionMap = new HashMap<String, JingleMediaSession>();
        this.registerInstance();
        this.installConnectionListeners(conn);
    }

    public JingleSession(XMPPConnection conn, JingleSessionRequest request, String initiator, String responder, List<JingleMediaManager> jingleMediaManagers) {
        this(conn, initiator, responder, JingleSession.generateSessionId(), jingleMediaManagers);
        this.sessionRequest = request;
    }

    public String getInitiator() {
        return this.initiator;
    }

    @Override
    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public List<JingleMediaManager> getMediaManagers() {
        return this.jingleMediaManagers;
    }

    public void setMediaManagers(List<JingleMediaManager> jingleMediaManagers) {
        this.jingleMediaManagers = jingleMediaManagers;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setResponder(String responder) {
        this.responder = responder;
    }

    public String getSid() {
        return this.sid;
    }

    protected void setSid(String sessionId) {
        this.sid = sessionId;
    }

    protected static String generateSessionId() {
        return String.valueOf(Math.abs(randomGenerator.nextLong()));
    }

    public void setSessionState(JingleSessionState stateIs) {
        LOGGER.debug("Session state change: " + this.sessionState + "->" + stateIs);
        stateIs.enter();
        this.sessionState = stateIs;
    }

    public JingleSessionState getSessionState() {
        return this.sessionState;
    }

    public boolean isFullyEstablished() {
        boolean result = true;
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.isFullyEstablished()) continue;
            result = false;
        }
        return result;
    }

    public synchronized void receivePacketAndRespond(IQ iq) throws XMPPException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        String responseId = null;
        LOGGER.debug("Packet: " + iq.toXML());
        try {
            responses.addAll(this.dispatchIncomingPacket(iq, null));
            if (iq != null) {
                responseId = iq.getPacketID();
                for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
                    responses.addAll(contentNegotiator.dispatchIncomingPacket(iq, responseId));
                }
            }
        }
        catch (JingleException e) {
            JingleError error = e.getError();
            if (error != null) {
                responses.add(this.createJingleError(iq, error));
            }
            this.triggerSessionClosedOnError(e);
        }
        for (IQ response : responses) {
            this.sendPacket(response);
        }
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iq, String id) throws XMPPException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        Object response = null;
        if (iq != null && !iq.getType().equals(IQ.Type.ERROR)) {
            if (iq.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iq.getPacketID())) {
                    if (iq.getPacketID().equals(this.sessionInitPacketID)) {
                        this.startNegotiators();
                    }
                    this.removeExpectedId(iq.getPacketID());
                }
            } else if (iq instanceof Jingle) {
                Jingle jin = (Jingle)iq;
                JingleActionEnum action = jin.getAction();
                this.getSessionState().processJingle(this, jin, action);
            }
        }
        if (response != null) {
            this.addExpectedId(response.getPacketID());
            responses.add((IQ)response);
        }
        return responses;
    }

    public void addContentNegotiator(ContentNegotiator inContentNegotiator) {
        this.contentNegotiators.add(inContentNegotiator);
    }

    public void sendPacket(IQ iq) {
        if (iq instanceof Jingle) {
            this.sendFormattedJingle((Jingle)iq);
        } else {
            this.getConnection().sendPacket((Packet)iq);
        }
    }

    public Jingle sendFormattedJingle(Jingle jout) {
        return this.sendFormattedJingle(null, jout);
    }

    public Jingle sendFormattedJingle(IQ iq, Jingle jout) {
        if (jout != null) {
            String other;
            if (jout.getInitiator() == null) {
                jout.setInitiator(this.getInitiator());
            }
            if (jout.getResponder() == null) {
                jout.setResponder(this.getResponder());
            }
            if (jout.getSid() == null) {
                jout.setSid(this.getSid());
            }
            String me = this.getConnection().getUser();
            String string = other = this.getResponder().equals(me) ? this.getInitiator() : this.getResponder();
            if (jout.getTo() == null) {
                if (iq != null) {
                    jout.setTo(iq.getFrom());
                } else {
                    jout.setTo(other);
                }
            }
            if (jout.getFrom() == null) {
                if (iq != null) {
                    jout.setFrom(iq.getTo());
                } else {
                    jout.setFrom(me);
                }
            }
            if (this.getConnection() != null && this.getConnection().isConnected()) {
                this.getConnection().sendPacket((Packet)jout);
            }
        }
        return jout;
    }

    private void sendPendingStateAction(Jingle inJingle, JingleActionEnum inAction) {
    }

    private void sendActiveStateAction(Jingle inJingle, JingleActionEnum inAction) {
    }

    private void sendEndedStateAction(Jingle inJingle, JingleActionEnum inAction) {
    }

    public IQ createAck(IQ iq) {
        IQ result = null;
        if (iq != null && iq.getType().equals(IQ.Type.SET)) {
            IQ ack;
            result = ack = JingleSession.createIQ(iq.getPacketID(), iq.getFrom(), iq.getTo(), IQ.Type.RESULT);
        }
        return result;
    }

    public int hashCode() {
        return Jingle.getSessionHash(this.getSid(), this.getInitiator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JingleSession other = (JingleSession)obj;
        if (this.initiator == null) {
            if (other.initiator != null) {
                return false;
            }
        } else if (!this.initiator.equals(other.initiator)) {
            // empty if block
        }
        if (this.responder == null ? other.responder != null : !this.responder.equals(other.responder)) {
            return false;
        }
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInstanceFor(XMPPConnection connection) {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstance() {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.put(this.getConnection(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JingleSession getInstanceFor(XMPPConnection con) {
        if (con == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        JingleSession result = null;
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(con)) {
                result = (JingleSession)sessions.get(con);
            }
        }
        return result;
    }

    private void installConnectionListeners(final XMPPConnection connection) {
        if (connection != null) {
            this.connectionListener = new ConnectionListener(){

                public void connectionClosed() {
                    JingleSession.this.unregisterInstanceFor(connection);
                }

                public void connectionClosedOnError(Exception e) {
                    JingleSession.this.unregisterInstanceFor(connection);
                }

                public void reconnectingIn(int i) {
                }

                public void reconnectionSuccessful() {
                }

                public void reconnectionFailed(Exception exception) {
                }
            };
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.getConnection().removeConnectionListener(this.connectionListener);
            LOGGER.debug("JINGLE SESSION: REMOVE CONNECTION LISTENER");
        }
    }

    protected void removePacketListener() {
        if (this.packetListener != null) {
            this.getConnection().removePacketListener(this.packetListener);
            LOGGER.debug("JINGLE SESSION: REMOVE PACKET LISTENER");
        }
    }

    protected void updatePacketListener() {
        this.removePacketListener();
        LOGGER.debug("UpdatePacketListener");
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                try {
                    JingleSession.this.receivePacketAndRespond((IQ)packet);
                }
                catch (XMPPException e) {
                    e.printStackTrace();
                }
            }
        };
        this.packetFilter = new PacketFilter(){

            public boolean accept(Packet packet) {
                if (packet instanceof IQ) {
                    String other;
                    IQ iq = (IQ)packet;
                    String me = JingleSession.this.getConnection().getUser();
                    if (!iq.getTo().equals(me)) {
                        return false;
                    }
                    String string = other = JingleSession.this.getResponder().equals(me) ? JingleSession.this.getInitiator() : JingleSession.this.getResponder();
                    if (iq.getFrom() == null || !iq.getFrom().equals(other == null ? "" : other)) {
                        return false;
                    }
                    if (iq instanceof Jingle) {
                        Jingle jin = (Jingle)iq;
                        String sid = jin.getSid();
                        if (sid == null || !sid.equals(JingleSession.this.getSid())) {
                            LOGGER.debug("Ignored Jingle(SID) " + sid + "|" + JingleSession.this.getSid() + " :" + iq.toXML());
                            return false;
                        }
                        String ini = jin.getInitiator();
                        if (!ini.equals(JingleSession.this.getInitiator())) {
                            LOGGER.debug("Ignored Jingle(INI): " + iq.toXML());
                            return false;
                        }
                    } else {
                        if (iq.getType().equals(IQ.Type.SET)) {
                            LOGGER.debug("Ignored Jingle(TYPE): " + iq.toXML());
                            return false;
                        }
                        if (iq.getType().equals(IQ.Type.GET)) {
                            LOGGER.debug("Ignored Jingle(TYPE): " + iq.toXML());
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        this.getConnection().addPacketListener(this.packetListener, this.packetFilter);
    }

    public void addMediaListener(JingleMediaListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getMediaNegotiator() == null) continue;
            contentNegotiator.getMediaNegotiator().addListener(li);
        }
    }

    public void removeMediaListener(JingleMediaListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getMediaNegotiator() == null) continue;
            contentNegotiator.getMediaNegotiator().removeListener(li);
        }
    }

    public void addTransportListener(JingleTransportListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getTransportNegotiator() == null) continue;
            contentNegotiator.getTransportNegotiator().addListener(li);
        }
    }

    public void removeTransportListener(JingleTransportListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getTransportNegotiator() == null) continue;
            contentNegotiator.getTransportNegotiator().removeListener(li);
        }
    }

    public void setupListeners() {
        JingleMediaListener jingleMediaListener = new JingleMediaListener(){

            public void mediaClosed(PayloadType cand) {
            }

            public void mediaEstablished(PayloadType pt) {
                if (JingleSession.this.isFullyEstablished()) {
                    Jingle jout = new Jingle(JingleActionEnum.SESSION_ACCEPT);
                    for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                        if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                        jout.addContent(contentNegotiator.getJingleContent());
                    }
                    JingleSession.this.addExpectedId(jout.getPacketID());
                    JingleSession.this.sendPacket(jout);
                }
            }
        };
        JingleTransportListener jingleTransportListener = new JingleTransportListener(){

            public void transportEstablished(TransportCandidate local, TransportCandidate remote) {
                if (JingleSession.this.isFullyEstablished()) {
                    JingleSession.this.setSessionState(JingleSessionStateActive.getInstance());
                    for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                        if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                        contentNegotiator.triggerContentEstablished();
                    }
                    if (JingleSession.this.getSessionState().equals(JingleSessionStatePending.getInstance())) {
                        Jingle jout = new Jingle(JingleActionEnum.SESSION_ACCEPT);
                        for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                            if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                            jout.addContent(contentNegotiator.getJingleContent());
                        }
                        JingleSession.this.addExpectedId(jout.getPacketID());
                        JingleSession.this.sendPacket(jout);
                    }
                }
            }

            public void transportClosed(TransportCandidate cand) {
            }

            public void transportClosedOnError(XMPPException e) {
            }
        };
        this.addMediaListener(jingleMediaListener);
        this.addTransportListener(jingleTransportListener);
    }

    protected void triggerSessionClosed(String reason) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionClosed(reason, this);
        }
        this.close();
    }

    protected void triggerSessionClosedOnError(XMPPException exc) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            contentNegotiator.stopJingleMediaSession();
            for (TransportCandidate candidate : contentNegotiator.getTransportNegotiator().getOfferedCandidates()) {
                candidate.removeCandidateEcho();
            }
        }
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionClosedOnError(exc, this);
        }
        this.close();
    }

    protected void triggerMediaReceived(String participant) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionMediaReceived(this, participant);
        }
    }

    public void terminate() throws XMPPException {
        this.terminate("Closed Locally");
    }

    public void terminate(String reason) throws XMPPException {
        if (this.isClosed()) {
            return;
        }
        LOGGER.debug("Terminate " + reason);
        Jingle jout = new Jingle(JingleActionEnum.SESSION_TERMINATE);
        jout.setType(IQ.Type.SET);
        this.sendPacket(jout);
        this.triggerSessionClosed(reason);
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.setSessionState(JingleSessionStateEnded.getInstance());
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            contentNegotiator.stopJingleMediaSession();
            for (TransportCandidate candidate : contentNegotiator.getTransportNegotiator().getOfferedCandidates()) {
                candidate.removeCandidateEcho();
            }
            contentNegotiator.close();
        }
        this.removePacketListener();
        this.removeConnectionListener();
        this.getConnection().removeConnectionListener(this.connectionListener);
        LOGGER.debug("Negotiation Closed: " + this.getConnection().getUser() + " " + this.sid);
        super.close();
    }

    public boolean isClosed() {
        return this.getSessionState().equals(JingleSessionStateEnded.getInstance());
    }

    public static IQ createIQ(String ID, String to, String from, IQ.Type type) {
        IQ iqPacket = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iqPacket.setPacketID(ID);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        iqPacket.setType(type);
        return iqPacket;
    }

    public static IQ createError(String ID, String to, String from, int errCode, XMPPError error) {
        IQ iqError = JingleSession.createIQ(ID, to, from, IQ.Type.ERROR);
        iqError.setError(error);
        LOGGER.debug("Created Error Packet:" + iqError.toXML());
        return iqError;
    }

    public IQ createJingleError(IQ iq, JingleError jingleError) {
        IQ errorPacket = null;
        if (jingleError != null) {
            errorPacket = JingleSession.createIQ(this.getSid(), iq.getFrom(), iq.getTo(), IQ.Type.ERROR);
            ArrayList<JingleError> extList = new ArrayList<JingleError>();
            extList.add(jingleError);
            XMPPError error = new XMPPError(0, XMPPError.Type.CANCEL, jingleError.toString(), "", extList);
            errorPacket.setPacketID(iq.getPacketID());
            errorPacket.setError(error);
            LOGGER.error("Error sent: " + errorPacket.toXML());
        }
        return errorPacket;
    }

    @Override
    public void mediaReceived(String participant) {
        this.triggerMediaReceived(participant);
    }

    public void startOutgoing() throws IllegalStateException {
        this.updatePacketListener();
        this.setSessionState(JingleSessionStatePending.getInstance());
        Jingle jingle = new Jingle(JingleActionEnum.SESSION_INITIATE);
        for (JingleMediaManager mediaManager : this.getMediaManagers()) {
            ContentNegotiator contentNeg = new ContentNegotiator(this, "initiator", mediaManager.getName());
            contentNeg.setMediaNegotiator(new MediaNegotiator(this, mediaManager, mediaManager.getPayloads(), contentNeg));
            JingleTransportManager transportManager = mediaManager.getTransportManager();
            TransportResolver resolver = null;
            try {
                resolver = transportManager.getResolver(this);
            }
            catch (XMPPException e) {
                e.printStackTrace();
            }
            if (resolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
                contentNeg.setTransportNegotiator(new TransportNegotiator.RawUdp(this, resolver, contentNeg));
            }
            if (resolver.getType().equals((Object)TransportResolver.Type.ice)) {
                contentNeg.setTransportNegotiator(new TransportNegotiator.Ice(this, resolver, contentNeg));
            }
            this.addContentNegotiator(contentNeg);
        }
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            jingle.addContent(contentNegotiator.getJingleContent());
        }
        this.sessionInitPacketID = jingle.getPacketID();
        this.sendPacket(jingle);
        this.setupListeners();
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            contentNegotiator.start();
        }
    }

    public void startIncoming() {
    }

    private void startNegotiators() {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            TransportNegotiator transNeg = contentNegotiator.getTransportNegotiator();
            transNeg.start();
        }
    }

    public void addJingleMediaSession(String mediaManagerName, JingleMediaSession mediaSession) {
        this.mediaSessionMap.put(mediaManagerName, mediaSession);
    }

    public JingleMediaSession getMediaSession(String mediaManagerName) {
        return this.mediaSessionMap.get(mediaManagerName);
    }
}

