package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.ServiceConnection;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.view.animation.AnimationUtils;
import com.beem.project.beem.R;
import android.util.Log;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.service.aidl.IXmppConnection;
import com.beem.project.beem.service.aidl.IXmppFacade;

/**
 * This class is an activity which display an animation during the connection
 * with the server.
 * @author Da Risk <darisk972@gmail.com>
 */
public class LoginAnim extends Activity {

    private static final String TAG = "LoginAnim";
    private static final Intent SERVICE_INTENT = new Intent();
    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }
    private ImageView mLogo;
    private Animation mRotateAnim;
    private final ServiceConnection mServConn = new LoginServiceConnection();
    private IXmppFacade mXmppFacade;
    private AsyncTask<IXmppFacade, Void, Boolean>mTask;

    /**
     * Constructor.
     */
    public LoginAnim() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.login_anim);
	mLogo = (ImageView) findViewById(R.id.logo_anim);
	mRotateAnim = AnimationUtils.loadAnimation(this, R.anim.rotate_and_scale);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onStart() {
	super.onStart();
        mLogo.startAnimation(mRotateAnim);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onResume() {
	super.onResume();
	if (mTask == null) {
	    mTask = new LoginTask();
	}
	if (mXmppFacade == null) {
	    bindService(LoginAnim.SERVICE_INTENT, mServConn, BIND_AUTO_CREATE);
	}
    }

    @Override
    protected void onPause() {
	super.onPause();
	if (mXmppFacade != null) { // and async task not en cours
	    unbindService(mServConn);
	    mXmppFacade = null;
	}
    }

    class LoginTask extends AsyncTask<IXmppFacade, Void, Boolean> {

	@Override
	protected Boolean doInBackground(IXmppFacade ... params) {
	    boolean result = true;
	    IXmppFacade facade = params[0];
	    try {
		IXmppConnection connect = facade.createConnection();
		if (!connect.isAuthentificated()) {
		    result = connect.connectSync();
		    if (!result) {
			// set bad message ?
		    }
		}
	    } catch (RemoteException e) {
		Log.d(TAG, "Error while connecting", e);
		// set bad message ?
		result = false;
	    }
	    Log.d(TAG, "Connection result? " + result);
	    return result;
	}

	@Override
	protected void onPostExecute(Boolean result) {
	    if (result == null || !result) { // Task cancelled on exception
		Log.d(TAG, "Exception or cancelation of the connection");
	    } else {
		LoginAnim.this.startActivity(new Intent(LoginAnim.this, ContactList.class));
		LoginAnim.this.finish();
	    }
	}

    }

    private class LoginServiceConnection implements ServiceConnection {

	public LoginServiceConnection() {
	}

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	    Log.d(TAG, "Launch the task");
	    mTask = mTask.execute(mXmppFacade);
	}
	
	@Override
	public void onServiceDisconnected(ComponentName name) {
	    Log.d(TAG, "Service disconnected.");
	    mXmppFacade = null;
	}
    }
}
