/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class PacketReader {
    private Thread readerThread;
    private ExecutorService listenerExecutor;
    private XMPPConnection connection;
    private XmlPullParser parser;
    private boolean done;
    private String connectionID = null;
    private Semaphore connectionSemaphore;

    protected PacketReader(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    protected void init() {
        this.done = false;
        this.connectionID = null;
        this.readerThread = new Thread(){

            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.connectionCounterValue + ")");
        this.readerThread.setDaemon(true);
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Smack Listener Processor (" + ((PacketReader)PacketReader.this).connection.connectionCounterValue + ")");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.resetParser();
    }

    public void startup() throws XMPPException {
        this.connectionSemaphore = new Semaphore(1);
        this.readerThread.start();
        try {
            this.connectionSemaphore.acquire();
            int n = SmackConfiguration.getPacketReplyTimeout();
            this.connectionSemaphore.tryAcquire(3 * n, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    public void shutdown() {
        if (!this.done) {
            for (ConnectionListener connectionListener : this.connection.getConnectionListeners()) {
                try {
                    connectionListener.connectionClosed();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.done = true;
        this.listenerExecutor.shutdown();
    }

    void cleanup() {
        this.connection.recvListeners.clear();
        this.connection.collectors.clear();
    }

    void notifyConnectionError(Exception exception) {
        this.done = true;
        this.connection.shutdown(new Presence(Presence.Type.unavailable));
        exception.printStackTrace();
        for (ConnectionListener connectionListener : this.connection.getConnectionListeners()) {
            try {
                connectionListener.connectionClosedOnError(exception);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected void notifyReconnection() {
        for (ConnectionListener connectionListener : this.connection.getConnectionListeners()) {
            try {
                connectionListener.reconnectionSuccessful();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void resetParser() {
        try {
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    private void parsePackets(Thread thread) {
        block32: {
            try {
                int n = this.parser.getEventType();
                do {
                    if (n == 2) {
                        if (this.parser.getName().equals("message")) {
                            this.processPacket(PacketParserUtils.parseMessage(this.parser));
                        } else if (this.parser.getName().equals("iq")) {
                            this.processPacket(PacketParserUtils.parseIQ(this.parser, this.connection));
                        } else if (this.parser.getName().equals("presence")) {
                            this.processPacket(PacketParserUtils.parsePresence(this.parser));
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (this.parser.getAttributeName(i).equals("id")) {
                                        this.connectionID = this.parser.getAttributeValue(i);
                                        if ("1.0".equals(this.parser.getAttributeValue("", "version"))) continue;
                                        this.releaseConnectionIDLock();
                                        continue;
                                    }
                                    if (!this.parser.getAttributeName(i).equals("from")) continue;
                                    this.connection.config.setServiceName(this.parser.getAttributeValue(i));
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException(PacketParserUtils.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String string = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(string)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(string)) {
                                    this.connection.streamCompressionDenied();
                                } else {
                                    SASLMechanism.Failure failure = PacketParserUtils.parseSASLFailure(this.parser);
                                    this.processPacket(failure);
                                    this.connection.getSASLAuthentication().authenticationFailed(failure.getCondition());
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                String string = this.parser.nextText();
                                this.processPacket(new SASLMechanism.Challenge(string));
                                this.connection.getSASLAuthentication().challengeReceived(string);
                            } else if (this.parser.getName().equals("success")) {
                                this.processPacket(new SASLMechanism.Success(this.parser.nextText()));
                                this.connection.packetWriter.openStream();
                                this.resetParser();
                                this.connection.getSASLAuthentication().authenticated();
                            } else if (this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (n == 3 && this.parser.getName().equals("stream")) {
                        this.connection.disconnect();
                    }
                    n = this.parser.next();
                } while (!this.done && n != 1 && thread == this.readerThread);
            }
            catch (Exception exception) {
                if (this.done) break block32;
                this.notifyConnectionError(exception);
            }
        }
    }

    private void releaseConnectionIDLock() {
        this.connectionSemaphore.release();
    }

    private void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector packetCollector : this.connection.getPacketCollectors()) {
            packetCollector.processPacket(packet);
        }
        this.listenerExecutor.submit(new ListenerNotification(packet));
    }

    private void parseFeatures(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl3) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("starttls")) {
                    bl = true;
                    continue;
                }
                if (xmlPullParser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (xmlPullParser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (xmlPullParser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(xmlPullParser));
                    continue;
                }
                if (!xmlPullParser.getName().equals("register")) continue;
                this.connection.getAccountManager().setSupportsAccountCreation(true);
                continue;
            }
            if (n != 3) continue;
            if (xmlPullParser.getName().equals("starttls")) {
                this.connection.startTLSReceived(bl2);
                continue;
            }
            if (xmlPullParser.getName().equals("required") && bl) {
                bl2 = true;
                continue;
            }
            if (!xmlPullParser.getName().equals("features")) continue;
            bl3 = true;
        }
        if (!this.connection.isSecureConnection() && !bl && this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new XMPPException("Server does not support security (TLS), but security required by connection configuration.", new XMPPError(XMPPError.Condition.forbidden));
        }
        if (!bl || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.releaseConnectionIDLock();
        }
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        public void run() {
            for (Connection.ListenerWrapper listenerWrapper : ((PacketReader)PacketReader.this).connection.recvListeners.values()) {
                listenerWrapper.notifyListener(this.packet);
            }
        }
    }
}

