/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class AndFilter
implements PacketFilter {
    private List<PacketFilter> filters = new ArrayList<PacketFilter>();

    public AndFilter() {
    }

    public AndFilter(PacketFilter ... packetFilterArray) {
        if (packetFilterArray == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        for (PacketFilter packetFilter : packetFilterArray) {
            if (packetFilter == null) {
                throw new IllegalArgumentException("Parameter cannot be null.");
            }
            this.filters.add(packetFilter);
        }
    }

    public void addFilter(PacketFilter packetFilter) {
        if (packetFilter == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        this.filters.add(packetFilter);
    }

    public boolean accept(Packet packet) {
        for (PacketFilter packetFilter : this.filters) {
            if (packetFilter.accept(packet)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.filters.toString();
    }
}

