/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HMAC {
    private MessageDigest digest;
    private int blockLength;
    private byte[] ipad;
    private byte[] opad;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;

    private void init(byte[] byArray) {
        int n;
        if (byArray.length > this.blockLength) {
            byArray = this.digest.digest(byArray);
            this.digest.reset();
        }
        this.ipad = new byte[this.blockLength];
        this.opad = new byte[this.blockLength];
        for (n = 0; n < byArray.length; ++n) {
            this.ipad[n] = (byte)(byArray[n] ^ 0x36);
            this.opad[n] = (byte)(byArray[n] ^ 0x5C);
        }
        while (n < this.blockLength) {
            this.ipad[n] = 54;
            this.opad[n] = 92;
            ++n;
        }
        this.digest.update(this.ipad);
    }

    public HMAC(MessageDigest messageDigest, int n, byte[] byArray) {
        messageDigest.reset();
        this.digest = messageDigest;
        this.blockLength = n;
        this.init(byArray);
    }

    public HMAC(String string, int n, byte[] byArray) {
        try {
            this.digest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("unknown digest algorithm " + string);
        }
        this.blockLength = n;
        this.init(byArray);
    }

    public HMAC(MessageDigest messageDigest, byte[] byArray) {
        this(messageDigest, 64, byArray);
    }

    public HMAC(String string, byte[] byArray) {
        this(string, 64, byArray);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.digest.update(byArray);
    }

    public byte[] sign() {
        byte[] byArray = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.opad);
        return this.digest.digest(byArray);
    }

    public boolean verify(byte[] byArray) {
        return this.verify(byArray, false);
    }

    public boolean verify(byte[] byArray, boolean bl) {
        byte[] byArray2 = this.sign();
        if (bl && byArray.length < byArray2.length) {
            byte[] byArray3 = new byte[byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            byArray2 = byArray3;
        }
        return Arrays.equals(byArray, byArray2);
    }

    public void clear() {
        this.digest.reset();
        this.digest.update(this.ipad);
    }

    public int digestLength() {
        return this.digest.getDigestLength();
    }
}

