package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.BeemBroadcastReceiver;

/**
 * This activity class provides the view for user infos after long click on a correspondant.
 * @author marseille
 */
public class UserInfo extends Activity {

    private static final Intent SERVICE_INTENT = new Intent();
    private final ServiceConnection mServConn = new BeemServiceConnection();
    private String mJID;
    private Contact mContact;
    private IXmppFacade mXmppFacade;
    private BeemBroadcastReceiver mReceiver;

    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }

    /**
     * Constructor.
     */
    public UserInfo() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.userinfo);
	View v = (View) findViewById(R.id.userinfo_layout_alias);
	v.setOnClickListener(new AliasListener());

	mReceiver = new BeemBroadcastReceiver(mServConn);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onResume() {
	super.onResume();
	this.registerReceiver(mReceiver, new IntentFilter(BeemBroadcastReceiver.BEEM_CONNECTION_CLOSED));
	bindService(new Intent(this, BeemService.class), mServConn, BIND_AUTO_CREATE);
	mReceiver.setBinded();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onPause() {
	super.onPause();
	this.unregisterReceiver(mReceiver);
	if (mReceiver.isBinded())
	    unbindService(mServConn);
    }

    class AliasListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {

	    Dialog d = new ContactDialogAliasDialog();
	    d.show();
	}

    }

    public class ContactDialogAliasDialog extends Dialog {

	public ContactDialogAliasDialog() {
	    super(UserInfo.this);
	    setContentView(R.layout.contactdialogaliasdialog);
	    setTitle(mContact.getJID());
	    EditText nameText = (EditText) findViewById(R.id.CDAliasDialogName);
	    if (mContact.getName().length() == 0)
		nameText.setText(mContact.getJID());
	    else
		nameText.setText(mContact.getName());

	    Button ok = (Button) findViewById(R.id.CDAliasDialogOk);
	    ok.setOnClickListener(new View.OnClickListener() {

		@Override
		public void onClick(View v) {
		    IRoster r;
		    try {
			r = mXmppFacade.getRoster();
			if (r != null) {
			    EditText nameText = (EditText) findViewById(R.id.CDAliasDialogName);
			    String name = nameText.getText().toString();
			    if (name.length() == 0)
				name = mContact.getJID();
			    r.setContactName(mContact.getJID(), name);
			    mContact.setName(name);

			}
		    } catch (RemoteException e) {
			e.printStackTrace();
		    }
		    dismiss();
		}

	    });
	}

    }

    /**
     * The ServiceConnection used to connect to the Beem service.
     */
    private class BeemServiceConnection implements ServiceConnection {

	/**
	 * Constructor.
	 */
	public BeemServiceConnection() {
	}

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	    try {
		IRoster r = mXmppFacade.getRoster();
		if (r != null) {
		    String jidByUri = getIntent().getData().getEncodedSchemeSpecificPart();
		    mContact = r.getContact(jidByUri);
		    setTitle(mContact.getJID());
		}
	    } catch (RemoteException e) {
		e.printStackTrace();
	    }
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    mXmppFacade = null;
	}
    }
}
