/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.umlgraph.doclet.ClassMatcher;
import org.umlgraph.doclet.ContextMatcher;
import org.umlgraph.doclet.InterfaceMatcher;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.Options;
import org.umlgraph.doclet.PatternMatcher;
import org.umlgraph.doclet.StringUtil;
import org.umlgraph.doclet.SubclassMatcher;

public class View
implements OptionProvider {
    Map<ClassMatcher, List<String[]>> optionOverrides = new LinkedHashMap<ClassMatcher, List<String[]>>();
    ClassDoc viewDoc;
    OptionProvider provider;
    List<String[]> globalOptions;
    RootDoc root;

    public View(RootDoc root, ClassDoc c, OptionProvider provider) {
        this.viewDoc = c;
        this.provider = provider;
        this.root = root;
        Tag[] tags = c.tags();
        ClassMatcher currMatcher = null;
        this.globalOptions = new ArrayList<String[]>();
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].name().equals("@match")) {
                currMatcher = this.buildMatcher(tags[i].text());
                if (currMatcher == null) continue;
                this.optionOverrides.put(currMatcher, new ArrayList());
                continue;
            }
            if (!tags[i].name().equals("@opt")) continue;
            String[] opts = StringUtil.tokenize(tags[i].text());
            opts[0] = "-" + opts[0];
            if (currMatcher == null) {
                this.globalOptions.add(opts);
                continue;
            }
            this.optionOverrides.get(currMatcher).add(opts);
        }
    }

    private ClassMatcher buildMatcher(String tagText) {
        String[] strings = StringUtil.tokenize(tagText);
        if (strings.length < 2) {
            System.err.println("Skipping uncomplete @match tag, type missing: " + tagText + " in view " + this.viewDoc);
            return null;
        }
        try {
            if (strings[0].equals("class")) {
                return new PatternMatcher(Pattern.compile(strings[1]));
            }
            if (strings[0].equals("context")) {
                return new ContextMatcher(this.root, Pattern.compile(strings[1]), this.getGlobalOptions(), false);
            }
            if (strings[0].equals("outgoingContext")) {
                return new ContextMatcher(this.root, Pattern.compile(strings[1]), this.getGlobalOptions(), false);
            }
            if (strings[0].equals("interface")) {
                return new InterfaceMatcher(this.root, Pattern.compile(strings[1]));
            }
            if (strings[0].equals("subclass")) {
                return new SubclassMatcher(this.root, Pattern.compile(strings[1]));
            }
            System.err.println("Skipping @match tag, unknown match type, in view " + this.viewDoc);
        }
        catch (PatternSyntaxException pse) {
            System.err.println("Skipping @match tag due to invalid regular expression '" + tagText + "'" + " in view " + this.viewDoc);
        }
        catch (Exception e) {
            System.err.println("Skipping @match tag due to an internal error '" + tagText + "'" + " in view " + this.viewDoc);
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Options getOptionsFor(ClassDoc cd) {
        Options localOpt = this.getGlobalOptions();
        this.overrideForClass(localOpt, cd);
        localOpt.setOptions(cd);
        return localOpt;
    }

    @Override
    public Options getOptionsFor(String name) {
        Options localOpt = this.getGlobalOptions();
        this.overrideForClass(localOpt, name);
        return localOpt;
    }

    @Override
    public Options getGlobalOptions() {
        Options go = this.provider.getGlobalOptions();
        boolean outputSet = false;
        for (String[] opts : this.globalOptions) {
            if (opts[0].equals("-output")) {
                outputSet = true;
            }
            go.setOption(opts);
        }
        if (!outputSet) {
            go.setOption(new String[]{"-output", this.viewDoc.name() + ".dot"});
        }
        return go;
    }

    @Override
    public void overrideForClass(Options opt, ClassDoc cd) {
        this.provider.overrideForClass(opt, cd);
        for (ClassMatcher cm : this.optionOverrides.keySet()) {
            if (!cm.matches(cd)) continue;
            for (String[] override : this.optionOverrides.get(cm)) {
                opt.setOption(override);
            }
        }
    }

    @Override
    public void overrideForClass(Options opt, String className) {
        this.provider.overrideForClass(opt, className);
        for (ClassMatcher cm : this.optionOverrides.keySet()) {
            if (!cm.matches(className)) continue;
            for (String[] override : this.optionOverrides.get(cm)) {
                opt.setOption(override);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return "view " + this.viewDoc.name();
    }
}

