#!/usr/bin/env python3

import urllib.request
import argparse, sys
from xml.dom.minidom import parse, getDOMImplementation


def getJidsFromUrl(url):
    f = urllib.request.urlopen(url)
    indoc = parse(f)
    jids = []
    query = indoc.documentElement
    if query.localName == "query" :
        for item in query.getElementsByTagName("item"):
            jid = item.getAttribute("jid")
            jids.append(jid)
    return jids

def createDocument():
    impl = getDOMImplementation()
    return impl.createDocument(None, "resources", None)


def purge(elems):
    res = []
    for i in elems:
        if i not in res:
            res.append(i)
    return res

def appendStringElem(doc, node, jids):
    for i in jids:
        item = doc.createElement("item")
        text = doc.createTextNode(i)
        item.appendChild(text)
        node.appendChild(item)


parser = argparse.ArgumentParser(description='Collect some free xmpp services')
parser.add_argument('url', metavar="url",
        default=['http://xmpp.net/services.xml', "https://list.jabber.at/api/?format=services.xml"] , nargs='*',
        help='url to get the services')

parser.add_argument('-o', metavar="FILE", type=argparse.FileType('bw'),
        default = sys.stdout.buffer,
        help='send output to FILE')

args = parser.parse_args()

# collect the servers jid
jids = []
for url in args.url:
    jids += getJidsFromUrl(url)

jids = purge(jids)

# create the xml output document
outdoc = createDocument()
res_element = outdoc.documentElement
string_array_elem = outdoc.createElement('string-array')
res_element.appendChild(string_array_elem)
string_array_elem.setAttribute("name", "xmpp_server_list")
appendStringElem(outdoc, string_array_elem, jids)

# print result
f = args.o
f.write(outdoc.toprettyxml(encoding="utf-8"))

