/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.workgroup.agent.AgentRosterListener;
import org.jivesoftware.smackx.workgroup.packet.AgentStatus;
import org.jivesoftware.smackx.workgroup.packet.AgentStatusRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentRoster {
    private static final int EVENT_AGENT_ADDED = 0;
    private static final int EVENT_AGENT_REMOVED = 1;
    private static final int EVENT_PRESENCE_CHANGED = 2;
    private Connection connection;
    private String workgroupJID;
    private List<String> entries;
    private List<AgentRosterListener> listeners;
    private Map<String, Map<String, Presence>> presenceMap;
    boolean rosterInitialized = false;

    AgentRoster(Connection connection, String string) {
        this.connection = connection;
        this.workgroupJID = string;
        this.entries = new ArrayList<String>();
        this.listeners = new ArrayList<AgentRosterListener>();
        this.presenceMap = new HashMap<String, Map<String, Presence>>();
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(AgentStatusRequest.class);
        connection.addPacketListener(new AgentStatusListener(), packetTypeFilter);
        connection.addPacketListener(new PresencePacketListener(), new PacketTypeFilter(Presence.class));
        AgentStatusRequest agentStatusRequest = new AgentStatusRequest();
        agentStatusRequest.setTo(string);
        connection.sendPacket(agentStatusRequest);
    }

    public void reload() {
        AgentStatusRequest agentStatusRequest = new AgentStatusRequest();
        agentStatusRequest.setTo(this.workgroupJID);
        this.connection.sendPacket(agentStatusRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AgentRosterListener agentRosterListener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(agentRosterListener)) {
                this.listeners.add(agentRosterListener);
                for (String string : this.getAgents()) {
                    if (!this.entries.contains(string)) continue;
                    agentRosterListener.agentAdded(string);
                    Map<String, Presence> map = this.presenceMap.get(string);
                    if (map == null) continue;
                    Iterator<Presence> iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        agentRosterListener.presenceChanged(iterator.next());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AgentRosterListener agentRosterListener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(agentRosterListener);
        }
    }

    public int getAgentCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAgents() {
        HashSet<String> hashSet = new HashSet<String>();
        List<String> list = this.entries;
        synchronized (list) {
            Iterator<String> iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        List<String> list = this.entries;
        synchronized (list) {
            for (String string2 : this.entries) {
                if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public Presence getPresence(String string) {
        String string2 = this.getPresenceMapKey(string);
        Map<String, Presence> map = this.presenceMap.get(string2);
        if (map == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        Iterator<String> iterator = map.keySet().iterator();
        Presence presence = null;
        while (iterator.hasNext()) {
            Presence presence2 = map.get(iterator.next());
            if (presence == null) {
                presence = presence2;
                continue;
            }
            if (presence2.getPriority() <= presence.getPriority()) continue;
            presence = presence2;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(string);
            return presence;
        }
        return presence;
    }

    private String getPresenceMapKey(String string) {
        String string2 = string;
        if (!this.contains(string)) {
            string2 = StringUtils.parseBareAddress(string).toLowerCase();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int n, Object object) {
        AgentRosterListener[] agentRosterListenerArray = null;
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            agentRosterListenerArray = new AgentRosterListener[this.listeners.size()];
            this.listeners.toArray(agentRosterListenerArray);
        }
        block8: for (int i = 0; i < agentRosterListenerArray.length; ++i) {
            switch (n) {
                case 0: {
                    agentRosterListenerArray[i].agentAdded((String)object);
                    continue block8;
                }
                case 1: {
                    agentRosterListenerArray[i].agentRemoved((String)object);
                    continue block8;
                }
                case 2: {
                    agentRosterListenerArray[i].presenceChanged((Presence)object);
                }
            }
        }
    }

    private class AgentStatusListener
    implements PacketListener {
        private AgentStatusListener() {
        }

        public void processPacket(Packet packet) {
            if (packet instanceof AgentStatusRequest) {
                AgentStatusRequest agentStatusRequest = (AgentStatusRequest)packet;
                for (AgentStatusRequest.Item item : agentStatusRequest.getAgents()) {
                    String string = item.getJID();
                    if ("remove".equals(item.getType())) {
                        String string2 = StringUtils.parseName(StringUtils.parseName(string) + "@" + StringUtils.parseServer(string));
                        AgentRoster.this.presenceMap.remove(string2);
                        AgentRoster.this.fireEvent(1, string);
                        continue;
                    }
                    AgentRoster.this.entries.add(string);
                    AgentRoster.this.fireEvent(0, string);
                }
                AgentRoster.this.rosterInitialized = true;
            }
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            Presence presence = (Presence)packet;
            String string = presence.getFrom();
            if (string == null) {
                System.out.println("Presence with no FROM: " + presence.toXML());
                return;
            }
            String string2 = AgentRoster.this.getPresenceMapKey(string);
            if (presence.getType() == Presence.Type.available) {
                Map<String, Presence> map;
                AgentStatus agentStatus = (AgentStatus)presence.getExtension("agent-status", "http://jabber.org/protocol/workgroup");
                if (agentStatus == null) {
                    return;
                }
                if (!AgentRoster.this.workgroupJID.equals(agentStatus.getWorkgroupJID())) {
                    return;
                }
                if (AgentRoster.this.presenceMap.get(string2) == null) {
                    map = new HashMap();
                    AgentRoster.this.presenceMap.put(string2, map);
                } else {
                    map = (Map)AgentRoster.this.presenceMap.get(string2);
                }
                Object object = map;
                synchronized (object) {
                    map.put(StringUtils.parseResource(string), presence);
                }
                object = AgentRoster.this.entries;
                synchronized (object) {
                    for (String string3 : AgentRoster.this.entries) {
                        if (!string3.toLowerCase().equals(StringUtils.parseBareAddress(string2).toLowerCase())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
            if (presence.getType() == Presence.Type.unavailable) {
                Iterator iterator;
                if (AgentRoster.this.presenceMap.get(string2) != null) {
                    Iterator iterator2 = iterator = (Map)AgentRoster.this.presenceMap.get(string2);
                    synchronized (iterator2) {
                        iterator.remove(StringUtils.parseResource(string));
                    }
                    if (iterator.isEmpty()) {
                        AgentRoster.this.presenceMap.remove(string2);
                    }
                }
                iterator = AgentRoster.this.entries;
                synchronized (iterator) {
                    for (String string4 : AgentRoster.this.entries) {
                        if (!string4.toLowerCase().equals(StringUtils.parseBareAddress(string2).toLowerCase())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
        }
    }
}

