/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xbill.DNS.Master;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

public class Zone
implements Serializable {
    private static final long serialVersionUID = -9220510891189510942L;
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private Map data;
    private Name origin;
    private Object originNode;
    private int dclass = 1;
    private RRset NS;
    private SOARecord SOA;
    private boolean hasWild;

    private void validate() throws IOException {
        this.originNode = this.exactName(this.origin);
        if (this.originNode == null) {
            throw new IOException(this.origin + ": no data specified");
        }
        RRset rRset = this.oneRRset(this.originNode, 6);
        if (rRset == null || rRset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        Iterator iterator = rRset.rrs();
        this.SOA = (SOARecord)iterator.next();
        this.NS = this.oneRRset(this.originNode, 2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    private final void maybeAddRecord(Record record) throws IOException {
        int n = record.getType();
        Name name = record.getName();
        if (n == 6 && !name.equals(this.origin)) {
            throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        }
    }

    public Zone(Name name, String string) throws IOException {
        Record record;
        this.data = new HashMap();
        if (name == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        Master master = new Master(string, name);
        this.origin = name;
        while ((record = master.nextRecord()) != null) {
            this.maybeAddRecord(record);
        }
        this.validate();
    }

    public Zone(Name name, Record[] recordArray) throws IOException {
        this.data = new HashMap();
        if (name == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        this.origin = name;
        for (int i = 0; i < recordArray.length; ++i) {
            this.maybeAddRecord(recordArray[i]);
        }
        this.validate();
    }

    private void fromXFR(ZoneTransferIn zoneTransferIn) throws IOException, ZoneTransferException {
        this.data = new HashMap();
        this.origin = zoneTransferIn.getName();
        List list = zoneTransferIn.run();
        for (Record record : list) {
            this.maybeAddRecord(record);
        }
        if (!zoneTransferIn.isAXFR()) {
            throw new IllegalArgumentException("zones can only be created from AXFRs");
        }
        this.validate();
    }

    public Zone(ZoneTransferIn zoneTransferIn) throws IOException, ZoneTransferException {
        this.fromXFR(zoneTransferIn);
    }

    public Zone(Name name, int n, String string) throws IOException, ZoneTransferException {
        ZoneTransferIn zoneTransferIn = ZoneTransferIn.newAXFR(name, string, null);
        zoneTransferIn.setDClass(n);
        this.fromXFR(zoneTransferIn);
    }

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return this.NS;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    public int getDClass() {
        return this.dclass;
    }

    private synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private synchronized RRset[] allRRsets(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.toArray(new RRset[list.size()]);
        }
        RRset rRset = (RRset)object;
        return new RRset[]{rRset};
    }

    private synchronized RRset oneRRset(Object object, int n) {
        if (n == 255) {
            throw new IllegalArgumentException("oneRRset(ANY)");
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                RRset rRset = (RRset)list.get(i);
                if (rRset.getType() != n) continue;
                return rRset;
            }
        } else {
            RRset rRset = (RRset)object;
            if (rRset.getType() == n) {
                return rRset;
            }
        }
        return null;
    }

    private synchronized RRset findRRset(Name name, int n) {
        Object object = this.exactName(name);
        if (object == null) {
            return null;
        }
        return this.oneRRset(object, n);
    }

    private synchronized void addRRset(Name name, RRset rRset) {
        Object v;
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        if ((v = this.data.get(name)) == null) {
            this.data.put(name, rRset);
            return;
        }
        int n = rRset.getType();
        if (v instanceof List) {
            List list = (List)v;
            for (int i = 0; i < list.size(); ++i) {
                RRset rRset2 = (RRset)list.get(i);
                if (rRset2.getType() != n) continue;
                list.set(i, rRset);
                return;
            }
            list.add(rRset);
        } else {
            RRset rRset3 = (RRset)v;
            if (rRset3.getType() == n) {
                this.data.put(name, rRset);
            } else {
                LinkedList<RRset> linkedList = new LinkedList<RRset>();
                linkedList.add(rRset3);
                linkedList.add(rRset);
                this.data.put(name, linkedList);
            }
        }
    }

    private synchronized void removeRRset(Name name, int n) {
        Object v = this.data.get(name);
        if (v == null) {
            return;
        }
        if (v instanceof List) {
            List list = (List)v;
            for (int i = 0; i < list.size(); ++i) {
                RRset rRset = (RRset)list.get(i);
                if (rRset.getType() != n) continue;
                list.remove(i);
                if (list.size() == 0) {
                    this.data.remove(name);
                }
                return;
            }
        } else {
            RRset rRset = (RRset)v;
            if (rRset.getType() != n) {
                return;
            }
            this.data.remove(name);
        }
    }

    private synchronized SetResponse lookup(Name name, int n) {
        RRset rRset;
        Object object;
        Name name2;
        int n2;
        int n3;
        if (!name.subdomain(this.origin)) {
            return SetResponse.ofType(1);
        }
        int n4 = name.labels();
        for (int i = n3 = this.origin.labels(); i <= n4; ++i) {
            RRset[] rRsetArray;
            boolean bl;
            n2 = i == n3 ? 1 : 0;
            boolean bl2 = bl = i == n4;
            name2 = n2 != 0 ? this.origin : (bl ? name : new Name(name, n4 - i));
            object = this.exactName(name2);
            if (object == null) continue;
            if (n2 == 0 && (rRsetArray = this.oneRRset(object, 2)) != null) {
                return new SetResponse(3, (RRset)rRsetArray);
            }
            if (bl && n == 255) {
                SetResponse setResponse = new SetResponse(6);
                rRsetArray = this.allRRsets(object);
                for (int j = 0; j < rRsetArray.length; ++j) {
                    setResponse.addRRset(rRsetArray[j]);
                }
                return setResponse;
            }
            if (bl) {
                rRset = this.oneRRset(object, n);
                if (rRset != null) {
                    SetResponse setResponse = new SetResponse(6);
                    setResponse.addRRset(rRset);
                    return setResponse;
                }
                rRset = this.oneRRset(object, 5);
                if (rRset != null) {
                    return new SetResponse(4, rRset);
                }
            } else {
                rRset = this.oneRRset(object, 39);
                if (rRset != null) {
                    return new SetResponse(5, rRset);
                }
            }
            if (!bl) continue;
            return SetResponse.ofType(2);
        }
        if (this.hasWild) {
            for (n2 = 0; n2 < n4 - n3; ++n2) {
                name2 = name.wild(n2 + 1);
                object = this.exactName(name2);
                if (object == null || (rRset = this.oneRRset(object, n)) == null) continue;
                SetResponse setResponse = new SetResponse(6);
                setResponse.addRRset(rRset);
                return setResponse;
            }
        }
        return SetResponse.ofType(1);
    }

    public SetResponse findRecords(Name name, int n) {
        return this.lookup(name, n);
    }

    public RRset findExactMatch(Name name, int n) {
        Object object = this.exactName(name);
        if (object == null) {
            return null;
        }
        return this.oneRRset(object, n);
    }

    public void addRRset(RRset rRset) {
        Name name = rRset.getName();
        this.addRRset(name, rRset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(Record record) {
        Name name = record.getName();
        int n = record.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rRset = this.findRRset(name, n);
            if (rRset == null) {
                rRset = new RRset(record);
                this.addRRset(name, rRset);
            } else {
                rRset.addRR(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(Record record) {
        Name name = record.getName();
        int n = record.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rRset = this.findRRset(name, n);
            if (rRset == null) {
                return;
            }
            if (rRset.size() == 1 && rRset.first().equals(record)) {
                this.removeRRset(name, n);
            } else {
                rRset.deleteRR(record);
            }
        }
    }

    public Iterator iterator() {
        return new ZoneIterator(false);
    }

    public Iterator AXFR() {
        return new ZoneIterator(true);
    }

    private void nodeToString(StringBuffer stringBuffer, Object object) {
        RRset[] rRsetArray = this.allRRsets(object);
        for (int i = 0; i < rRsetArray.length; ++i) {
            RRset rRset = rRsetArray[i];
            Iterator iterator = rRset.rrs();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + "\n");
            }
            iterator = rRset.sigs();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + "\n");
            }
        }
    }

    public synchronized String toMasterFile() {
        Iterator iterator = this.data.entrySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        this.nodeToString(stringBuffer, this.originNode);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.origin.equals(entry.getKey())) continue;
            this.nodeToString(stringBuffer, entry.getValue());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toMasterFile();
    }

    class ZoneIterator
    implements Iterator {
        private Iterator zentries;
        private RRset[] current;
        private int count;
        private boolean wantLastSOA;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZoneIterator(boolean bl) {
            RRset[] rRsetArray2 = Zone.this;
            synchronized (Zone.this) {
                this.zentries = ((Zone)Zone.this).data.entrySet().iterator();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.wantLastSOA = bl;
                rRsetArray2 = ((Zone)Zone.this).allRRsets(((Zone)Zone.this).originNode);
                this.current = new RRset[rRsetArray2.length];
                int n = 2;
                for (int i = 0; i < rRsetArray2.length; ++i) {
                    int n2 = rRsetArray2[i].getType();
                    if (n2 == 6) {
                        this.current[0] = rRsetArray2[i];
                        continue;
                    }
                    if (n2 == 2) {
                        this.current[1] = rRsetArray2[i];
                        continue;
                    }
                    this.current[n++] = rRsetArray2[i];
                }
                return;
            }
        }

        public boolean hasNext() {
            return this.current != null || this.wantLastSOA;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                this.wantLastSOA = false;
                return Zone.this.oneRRset(Zone.this.originNode, 6);
            }
            RRset rRset = this.current[this.count++];
            if (this.count == this.current.length) {
                this.current = null;
                while (this.zentries.hasNext()) {
                    RRset[] rRsetArray;
                    Map.Entry entry = (Map.Entry)this.zentries.next();
                    if (entry.getKey().equals(Zone.this.origin) || (rRsetArray = Zone.this.allRRsets(entry.getValue())).length == 0) continue;
                    this.current = rRsetArray;
                    this.count = 0;
                    break;
                }
            }
            return rRset;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

