/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class OPTRecord
extends Record {
    private static final long serialVersionUID = -6254521894809367938L;
    private List options;

    OPTRecord() {
    }

    @Override
    Record getObject() {
        return new OPTRecord();
    }

    public OPTRecord(int n, int n2, int n3, int n4, List list) {
        super(Name.root, 41, n, 0L);
        OPTRecord.checkU16("payloadSize", n);
        OPTRecord.checkU8("xrcode", n2);
        OPTRecord.checkU8("version", n3);
        OPTRecord.checkU16("flags", n4);
        this.ttl = ((long)n2 << 24) + ((long)n3 << 16) + (long)n4;
        if (list != null) {
            this.options = new ArrayList(list);
        }
    }

    public OPTRecord(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    public OPTRecord(int n, int n2, int n3) {
        this(n, n2, n3, 0, null);
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        if (dNSInput.remaining() > 0) {
            this.options = new ArrayList();
        }
        while (dNSInput.remaining() > 0) {
            EDNSOption eDNSOption = EDNSOption.fromWire(dNSInput);
            this.options.add(eDNSOption);
        }
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        throw tokenizer.exception("no text format defined for OPT");
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.options != null) {
            stringBuffer.append(this.options);
            stringBuffer.append(" ");
        }
        stringBuffer.append(" ; payload ");
        stringBuffer.append(this.getPayloadSize());
        stringBuffer.append(", xrcode ");
        stringBuffer.append(this.getExtendedRcode());
        stringBuffer.append(", version ");
        stringBuffer.append(this.getVersion());
        stringBuffer.append(", flags ");
        stringBuffer.append(this.getFlags());
        return stringBuffer.toString();
    }

    public int getPayloadSize() {
        return this.dclass;
    }

    public int getExtendedRcode() {
        return (int)(this.ttl >>> 24);
    }

    public int getVersion() {
        return (int)(this.ttl >>> 16 & 0xFFL);
    }

    public int getFlags() {
        return (int)(this.ttl & 0xFFFFL);
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        if (this.options == null) {
            return;
        }
        for (EDNSOption eDNSOption : this.options) {
            eDNSOption.toWire(dNSOutput);
        }
    }

    public List getOptions() {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.options);
    }

    public List getOptions(int n) {
        if (this.options == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EDNSOption> arrayList = Collections.EMPTY_LIST;
        for (EDNSOption eDNSOption : this.options) {
            if (eDNSOption.getCode() != n) continue;
            if (arrayList == Collections.EMPTY_LIST) {
                arrayList = new ArrayList<EDNSOption>();
            }
            arrayList.add(eDNSOption);
        }
        return arrayList;
    }
}

