/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base16;

public class APLRecord
extends Record {
    private static final long serialVersionUID = -1348173791712935864L;
    private List elements;

    APLRecord() {
    }

    @Override
    Record getObject() {
        return new APLRecord();
    }

    private static boolean validatePrefixLength(int n, int n2) {
        if (n2 < 0 || n2 >= 256) {
            return false;
        }
        return (n != 1 || n2 <= 32) && (n != 2 || n2 <= 128);
    }

    public APLRecord(Name name, int n, long l, List list) {
        super(name, 42, n, l);
        this.elements = new ArrayList(list.size());
        for (Object e : list) {
            if (!(e instanceof Element)) {
                throw new IllegalArgumentException("illegal element");
            }
            Element element = (Element)e;
            if (element.family != 1 && element.family != 2) {
                throw new IllegalArgumentException("unknown family");
            }
            this.elements.add(element);
        }
    }

    private static byte[] parseAddress(byte[] byArray, int n) throws WireParseException {
        if (byArray.length > n) {
            throw new WireParseException("invalid address length");
        }
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.elements = new ArrayList(1);
        while (dNSInput.remaining() != 0) {
            Element element;
            int n = dNSInput.readU16();
            int n2 = dNSInput.readU8();
            int n3 = dNSInput.readU8();
            boolean bl = (n3 & 0x80) != 0;
            byte[] byArray = dNSInput.readByteArray(n3 &= 0xFFFFFF7F);
            if (!APLRecord.validatePrefixLength(n, n2)) {
                throw new WireParseException("invalid prefix length");
            }
            if (n == 1 || n == 2) {
                byArray = APLRecord.parseAddress(byArray, Address.addressLength(n));
                InetAddress inetAddress = InetAddress.getByAddress(byArray);
                element = new Element(bl, inetAddress, n2);
            } else {
                element = new Element(n, bl, byArray, n2);
            }
            this.elements.add(element);
        }
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Tokenizer.Token token;
        this.elements = new ArrayList(1);
        while ((token = tokenizer.get()).isString()) {
            int n;
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            String string = token.value;
            int n4 = 0;
            if (string.startsWith("!")) {
                bl = true;
                n4 = 1;
            }
            if ((n = string.indexOf(58, n4)) < 0) {
                throw tokenizer.exception("invalid address prefix element");
            }
            int n5 = string.indexOf(47, n);
            if (n5 < 0) {
                throw tokenizer.exception("invalid address prefix element");
            }
            String string2 = string.substring(n4, n);
            String string3 = string.substring(n + 1, n5);
            String string4 = string.substring(n5 + 1);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw tokenizer.exception("invalid family");
            }
            if (n2 != 1 && n2 != 2) {
                throw tokenizer.exception("unknown family");
            }
            try {
                n3 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw tokenizer.exception("invalid prefix length");
            }
            if (!APLRecord.validatePrefixLength(n2, n3)) {
                throw tokenizer.exception("invalid prefix length");
            }
            byte[] byArray = Address.toByteArray(string3, n2);
            if (byArray == null) {
                throw tokenizer.exception("invalid IP address " + string3);
            }
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            this.elements.add(new Element(bl, inetAddress, n3));
        }
        tokenizer.unget();
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            stringBuffer.append(element);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public List getElements() {
        return this.elements;
    }

    private static int addressLength(byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] == 0) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        for (Element element : this.elements) {
            byte[] byArray;
            int n = 0;
            if (element.family == 1 || element.family == 2) {
                InetAddress inetAddress = (InetAddress)element.address;
                byArray = inetAddress.getAddress();
                n = APLRecord.addressLength(byArray);
            } else {
                byArray = (byte[])element.address;
                n = byArray.length;
            }
            int n2 = n;
            if (element.negative) {
                n2 |= 0x80;
            }
            dNSOutput.writeU16(element.family);
            dNSOutput.writeU8(element.prefixLength);
            dNSOutput.writeU8(n2);
            dNSOutput.writeByteArray(byArray, 0, n);
        }
    }

    public static class Element {
        public final int family;
        public final boolean negative;
        public final int prefixLength;
        public final Object address;

        private Element(int n, boolean bl, Object object, int n2) {
            this.family = n;
            this.negative = bl;
            this.address = object;
            this.prefixLength = n2;
            if (!APLRecord.validatePrefixLength(n, n2)) {
                throw new IllegalArgumentException("invalid prefix length");
            }
        }

        public Element(boolean bl, InetAddress inetAddress, int n) {
            this(Address.familyOf(inetAddress), bl, inetAddress, n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.negative) {
                stringBuffer.append("!");
            }
            stringBuffer.append(this.family);
            stringBuffer.append(":");
            if (this.family == 1 || this.family == 2) {
                stringBuffer.append(((InetAddress)this.address).getHostAddress());
            } else {
                stringBuffer.append(base16.toString((byte[])this.address));
            }
            stringBuffer.append("/");
            stringBuffer.append(this.prefixLength);
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Element)) {
                return false;
            }
            Element element = (Element)object;
            return this.family == element.family && this.negative == element.negative && this.prefixLength == element.prefixLength && this.address.equals(element.address);
        }

        public int hashCode() {
            return this.address.hashCode() + this.prefixLength + (this.negative ? 1 : 0);
        }
    }
}

