/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.FormattedTime;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class TKEYRecord
extends Record {
    private static final long serialVersionUID = 8828458121926391756L;
    private Name alg;
    private Date timeInception;
    private Date timeExpire;
    private int mode;
    private int error;
    private byte[] key;
    private byte[] other;
    public static final int SERVERASSIGNED = 1;
    public static final int DIFFIEHELLMAN = 2;
    public static final int GSSAPI = 3;
    public static final int RESOLVERASSIGNED = 4;
    public static final int DELETE = 5;

    TKEYRecord() {
    }

    Record getObject() {
        return new TKEYRecord();
    }

    public TKEYRecord(Name name, int n, long l, Name name2, Date date, Date date2, int n2, int n3, byte[] byArray, byte[] byArray2) {
        super(name, 249, n, l);
        this.alg = TKEYRecord.checkName("alg", name2);
        this.timeInception = date;
        this.timeExpire = date2;
        this.mode = TKEYRecord.checkU16("mode", n2);
        this.error = TKEYRecord.checkU16("error", n3);
        this.key = byArray;
        this.other = byArray2;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.alg = new Name(dNSInput);
        this.timeInception = new Date(1000L * dNSInput.readU32());
        this.timeExpire = new Date(1000L * dNSInput.readU32());
        this.mode = dNSInput.readU16();
        this.error = dNSInput.readU16();
        int n = dNSInput.readU16();
        this.key = (byte[])(n > 0 ? dNSInput.readByteArray(n) : null);
        int n2 = dNSInput.readU16();
        this.other = (byte[])(n2 > 0 ? dNSInput.readByteArray(n2) : null);
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        throw tokenizer.exception("no text format defined for TKEY");
    }

    protected String modeString() {
        switch (this.mode) {
            case 1: {
                return "SERVERASSIGNED";
            }
            case 2: {
                return "DIFFIEHELLMAN";
            }
            case 3: {
                return "GSSAPI";
            }
            case 4: {
                return "RESOLVERASSIGNED";
            }
            case 5: {
                return "DELETE";
            }
        }
        return Integer.toString(this.mode);
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.alg);
        stringBuffer.append(" ");
        if (Options.check("multiline")) {
            stringBuffer.append("(\n\t");
        }
        stringBuffer.append(FormattedTime.format(this.timeInception));
        stringBuffer.append(" ");
        stringBuffer.append(FormattedTime.format(this.timeExpire));
        stringBuffer.append(" ");
        stringBuffer.append(this.modeString());
        stringBuffer.append(" ");
        stringBuffer.append(Rcode.TSIGstring(this.error));
        if (Options.check("multiline")) {
            stringBuffer.append("\n");
            if (this.key != null) {
                stringBuffer.append(base64.formatString(this.key, 64, "\t", false));
                stringBuffer.append("\n");
            }
            if (this.other != null) {
                stringBuffer.append(base64.formatString(this.other, 64, "\t", false));
            }
            stringBuffer.append(" )");
        } else {
            stringBuffer.append(" ");
            if (this.key != null) {
                stringBuffer.append(base64.toString(this.key));
                stringBuffer.append(" ");
            }
            if (this.other != null) {
                stringBuffer.append(base64.toString(this.other));
            }
        }
        return stringBuffer.toString();
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeInception() {
        return this.timeInception;
    }

    public Date getTimeExpire() {
        return this.timeExpire;
    }

    public int getMode() {
        return this.mode;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getOther() {
        return this.other;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.alg.toWire(dNSOutput, null, bl);
        dNSOutput.writeU32(this.timeInception.getTime() / 1000L);
        dNSOutput.writeU32(this.timeExpire.getTime() / 1000L);
        dNSOutput.writeU16(this.mode);
        dNSOutput.writeU16(this.error);
        if (this.key != null) {
            dNSOutput.writeU16(this.key.length);
            dNSOutput.writeByteArray(this.key);
        } else {
            dNSOutput.writeU16(0);
        }
        if (this.other != null) {
            dNSOutput.writeU16(this.other.length);
            dNSOutput.writeByteArray(this.other);
        } else {
            dNSOutput.writeU16(0);
        }
    }
}

