/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.util.regex.Pattern;
import org.umlgraph.doclet.ContextMatcher;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.Options;

public class ContextView
implements OptionProvider {
    private ClassDoc cd;
    private ContextMatcher matcher;
    private Options globalOptions;
    private Options myGlobalOptions;
    private Options hideOptions;
    private Options centerOptions;
    private Options packageOptions;
    private static final String[] HIDE_OPTIONS = new String[]{"-hide"};

    public ContextView(String outputFolder, ClassDoc cd, RootDoc root, Options parent) throws IOException {
        this.cd = cd;
        String outputPath = cd.containingPackage().name().replace('.', '/') + "/" + cd.name() + ".dot";
        this.globalOptions = parent.getGlobalOptions();
        this.packageOptions = parent.getGlobalOptions();
        this.packageOptions.showQualified = false;
        this.myGlobalOptions = parent.getGlobalOptions();
        this.myGlobalOptions.setOption(new String[]{"-output", outputPath});
        this.myGlobalOptions.setOption(HIDE_OPTIONS);
        this.hideOptions = parent.getGlobalOptions();
        this.hideOptions.setOption(HIDE_OPTIONS);
        this.centerOptions = parent.getGlobalOptions();
        this.centerOptions.nodeFillColor = "lemonChiffon";
        this.centerOptions.showQualified = false;
        this.matcher = new ContextMatcher(root, Pattern.compile(cd.qualifiedName()), this.myGlobalOptions, true);
    }

    public void setContextCenter(ClassDoc contextCenter) {
        this.cd = contextCenter;
        String outputPath = this.cd.containingPackage().name().replace('.', '/') + "/" + this.cd.name() + ".dot";
        this.myGlobalOptions.setOption(new String[]{"-output", outputPath});
        this.matcher.setContextCenter(Pattern.compile(this.cd.toString()));
    }

    @Override
    public String getDisplayName() {
        return "Context view for class " + this.cd;
    }

    @Override
    public Options getGlobalOptions() {
        return this.myGlobalOptions;
    }

    @Override
    public Options getOptionsFor(ClassDoc cd) {
        if (this.globalOptions.matchesHideExpression(cd.toString()) || !this.matcher.matches(cd)) {
            return this.hideOptions;
        }
        if (cd.equals(this.cd)) {
            return this.centerOptions;
        }
        if (cd.containingPackage().equals(this.cd.containingPackage())) {
            return this.packageOptions;
        }
        return this.globalOptions;
    }

    @Override
    public Options getOptionsFor(String name) {
        if (!this.matcher.matches(name)) {
            return this.hideOptions;
        }
        if (name.equals(this.cd.name())) {
            return this.centerOptions;
        }
        return this.globalOptions;
    }

    @Override
    public void overrideForClass(Options opt, ClassDoc cd) {
        if (opt.matchesHideExpression(cd.toString()) || !this.matcher.matches(cd)) {
            opt.setOption(HIDE_OPTIONS);
        }
        if (cd.equals(this.cd)) {
            opt.nodeFillColor = "lemonChiffon";
        }
    }

    @Override
    public void overrideForClass(Options opt, String className) {
        if (!this.matcher.matches(className)) {
            opt.setOption(HIDE_OPTIONS);
        }
    }
}

