/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentStatusRequest
extends IQ {
    public static final String ELEMENT_NAME = "agent-status-request";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private Set<Item> agents = new HashSet<Item>();

    public int getAgentCount() {
        return this.agents.size();
    }

    public Set<Item> getAgents() {
        return Collections.unmodifiableSet(this.agents);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        Set<Item> set = this.agents;
        synchronized (set) {
            for (Item item : this.agents) {
                stringBuilder.append("<agent jid=\"").append(item.getJID()).append("\">");
                if (item.getName() != null) {
                    stringBuilder.append("<name xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
                    stringBuilder.append(item.getName());
                    stringBuilder.append("</name>");
                }
                stringBuilder.append("</agent>");
            }
        }
        stringBuilder.append("</").append(this.getElementName()).append("> ");
        return stringBuilder.toString();
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            AgentStatusRequest agentStatusRequest = new AgentStatusRequest();
            if (xmlPullParser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "agent".equals(xmlPullParser.getName())) {
                    agentStatusRequest.agents.add(this.parseAgent(xmlPullParser));
                    continue;
                }
                if (n != 3 || !AgentStatusRequest.ELEMENT_NAME.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return agentStatusRequest;
        }

        private Item parseAgent(XmlPullParser xmlPullParser) throws Exception {
            boolean bl = false;
            String string = xmlPullParser.getAttributeValue("", "jid");
            String string2 = xmlPullParser.getAttributeValue("", "type");
            String string3 = null;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2 && "name".equals(xmlPullParser.getName())) {
                    string3 = xmlPullParser.nextText();
                    continue;
                }
                if (n != 3 || !"agent".equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return new Item(string, string2, string3);
        }
    }

    public static class Item {
        private String jid;
        private String type;
        private String name;

        public Item(String string, String string2, String string3) {
            this.jid = string;
            this.type = string2;
            this.name = string3;
        }

        public String getJID() {
            return this.jid;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

