/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp;

import org.jlibrtp.jlibrtp.Participant;
import org.jlibrtp.jlibrtp.PktBufNode;
import org.jlibrtp.jlibrtp.RtpPkt;

public class DataFrame {
    private long rtpTimestamp;
    private long timestamp = -1L;
    private long SSRC;
    private long[] CSRCs;
    private int payloadType;
    private boolean[] marks;
    private boolean anyMarked = false;
    private int isComplete = 0;
    private byte[][] data;
    private int[] seqNum;
    private int totalLength = 0;
    protected int lastSeqNum;
    protected int firstSeqNum;
    protected int noPkts;

    protected DataFrame(PktBufNode aBufNode, Participant p, int noPkts) {
        this.noPkts = noPkts;
        RtpPkt aPkt = aBufNode.pkt;
        int pktCount = aBufNode.pktCount;
        this.firstSeqNum = aBufNode.pktCount;
        this.rtpTimestamp = aBufNode.timeStamp;
        this.SSRC = aPkt.getSsrc();
        this.CSRCs = aPkt.getCsrcArray();
        if (p.ntpGradient > 0.0) {
            this.timestamp = p.ntpOffset + (long)(p.ntpGradient * (double)(this.rtpTimestamp - p.lastSRRtpTs));
        }
        int payloadLength = aPkt.getPayloadLength();
        this.data = new byte[aBufNode.pktCount][payloadLength];
        this.seqNum = new int[aBufNode.pktCount];
        this.marks = new boolean[aBufNode.pktCount];
        int i = 0;
        while (i < pktCount) {
            aPkt = aBufNode.pkt;
            byte[] temp = aPkt.getPayload();
            this.totalLength += temp.length;
            if (temp.length == payloadLength) {
                this.data[i] = temp;
            } else if (temp.length < payloadLength) {
                System.arraycopy(temp, 0, this.data[i], 0, temp.length);
            } else {
                System.out.println("DataFrame() received node structure with increasing packet payload size.");
            }
            this.seqNum[i] = aBufNode.seqNum;
            this.marks[i] = aBufNode.pkt.isMarked();
            if (this.marks[i]) {
                this.anyMarked = true;
            }
            aBufNode = aBufNode.nextFrameNode;
            ++i;
        }
        this.lastSeqNum = this.seqNum[i - 1];
        if (noPkts > 0) {
            int seqDiff = this.firstSeqNum - this.lastSeqNum;
            if (seqDiff < 0) {
                seqDiff = Integer.MAX_VALUE - this.firstSeqNum + this.lastSeqNum;
            }
            if (seqDiff == pktCount && pktCount == noPkts) {
                this.isComplete = 1;
            }
        } else {
            this.isComplete = -1;
        }
    }

    public byte[][] getData() {
        return this.data;
    }

    public byte[] getConcatenatedData() {
        if (this.noPkts < 2) {
            byte[] ret = new byte[this.totalLength];
            int pos = 0;
            int i = 0;
            while (i < this.data.length) {
                int length = this.data[i].length;
                if (pos + length > this.totalLength) {
                    length = this.totalLength - pos;
                }
                System.arraycopy(this.data[i], 0, ret, pos, length);
                pos += this.data[i].length;
                ++i;
            }
            return ret;
        }
        return this.data[0];
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long rtpTimestamp() {
        return this.rtpTimestamp;
    }

    public int payloadType() {
        return this.payloadType;
    }

    public int[] sequenceNumbers() {
        return this.seqNum;
    }

    public boolean[] marks() {
        return this.marks;
    }

    public boolean marked() {
        return this.anyMarked;
    }

    public long ssrc() {
        return this.SSRC;
    }

    public long[] csrcs() {
        return this.CSRCs;
    }

    public int complete() {
        return this.isComplete;
    }
}

