package com.beem.project.beem.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.util.Log;
import android.widget.Toast;

import com.beem.project.beem.ui.Login;

/**
 * Manage broadcast disconnect intent.
 * @author nikita
 */
public class BeemBroadcastReceiver extends BroadcastReceiver {

    /**
     * Broadcast intent type.
     */
    public static final String BEEM_CONNECTION_CLOSED = "BeemConnectionClosed";
    private ServiceConnection mService;
    private boolean mIsBinded;

    /**
     * constructor.
     * @param service service observed
     */
    public BeemBroadcastReceiver(final ServiceConnection service) {
	mService = service;
	mIsBinded = false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onReceive(Context context, Intent intent) {
	Log.d("Broadcast","onREceive");
	context.unbindService(mService);
	mIsBinded = false;
	context.startActivity(new Intent(context, Login.class));
	CharSequence message = intent.getCharSequenceExtra("message");
	Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
    }

    /**
     * service is binded.
     */
    public void setBinded() {
	mIsBinded = true;
    }

    /**
     * return service bind status.
     * @return service bind status.
     */
    public boolean isBinded() {
	return mIsBinded;
    }
}
