package com.beem.project.beem.otr;

import com.beem.project.beem.service.ChatAdapter;

import net.java.otr4j.OtrEngine;
import net.java.otr4j.OtrEngineImpl;
import net.java.otr4j.session.SessionID;

public class BeemOtrManager {

	private static final BeemOtrEngineHostImpl mOtrHost= new BeemOtrEngineHostImpl();
	private static OtrEngine mOtrEngine = new OtrEngineImpl(mOtrHost);
	
	public static OtrEngine getOtrManager() {
		return mOtrEngine;
	}
	
	/*
	 * We must call addChat before stating a new otr session because we will need the chat instance for message injection
	 */
	public static void addChat(final SessionID sessionID, final ChatAdapter chat) {
		mOtrHost.addChat(sessionID, chat);
	}
	
	/*
	 * We must remove the chat from the map after we ended the corresponding otr session.
	 */
	public static void removeChat(final SessionID sessionID) {
		mOtrHost.removeChat(sessionID);
	}
}
