/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.media.PayloadType;

public abstract class JingleContentDescription
implements PacketExtension {
    public static final String NODENAME = "description";
    private final List payloads = new ArrayList();

    public String getElementName() {
        return NODENAME;
    }

    public abstract String getNamespace();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJinglePayloadType(JinglePayloadType pt) {
        List list = this.payloads;
        synchronized (list) {
            this.payloads.add(pt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioPayloadTypes(List pts) {
        List list = this.payloads;
        synchronized (list) {
            for (PayloadType.Audio pt : pts) {
                this.addJinglePayloadType(new JinglePayloadType.Audio(pt));
            }
        }
    }

    public Iterator getJinglePayloadTypes() {
        return Collections.unmodifiableList(this.getJinglePayloadTypesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getJinglePayloadTypesList() {
        List list = this.payloads;
        synchronized (list) {
            return new ArrayList(this.payloads);
        }
    }

    public ArrayList getAudioPayloadTypesList() {
        ArrayList<PayloadType> result = new ArrayList<PayloadType>();
        Iterator jinglePtsIter = this.getJinglePayloadTypes();
        while (jinglePtsIter.hasNext()) {
            JinglePayloadType jpt = (JinglePayloadType)jinglePtsIter.next();
            if (!(jpt instanceof JinglePayloadType.Audio)) continue;
            JinglePayloadType.Audio jpta = (JinglePayloadType.Audio)jpt;
            result.add(jpta.getPayloadType());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJinglePayloadTypesCount() {
        List list = this.payloads;
        synchronized (list) {
            return this.payloads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        List list = this.payloads;
        synchronized (list) {
            if (this.payloads.size() > 0) {
                buf.append("<").append(this.getElementName());
                buf.append(" xmlns=\"").append(this.getNamespace()).append("\" >");
                ListIterator pt = this.payloads.listIterator();
                while (pt.hasNext()) {
                    JinglePayloadType pte = (JinglePayloadType)pt.next();
                    buf.append(pte.toXML());
                }
                buf.append("</").append(this.getElementName()).append(">");
            }
        }
        return buf.toString();
    }

    public static class JinglePayloadType {
        public static final String NODENAME = "payload-type";
        private PayloadType payload;

        public JinglePayloadType(PayloadType payload) {
            this.payload = payload;
        }

        public JinglePayloadType() {
            this(null);
        }

        public static String getElementName() {
            return NODENAME;
        }

        public PayloadType getPayloadType() {
            return this.payload;
        }

        public void setPayload(PayloadType payload) {
            this.payload = payload;
        }

        protected String getChildAttributes() {
            return null;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            if (this.payload != null) {
                buf.append("<").append(JinglePayloadType.getElementName()).append(" ");
                if (this.payload.getId() != PayloadType.INVALID_PT) {
                    buf.append(" id=\"").append(this.payload.getId()).append("\"");
                }
                if (this.payload.getName() != null) {
                    buf.append(" name=\"").append(this.payload.getName()).append("\"");
                }
                if (this.payload.getChannels() != 0) {
                    buf.append(" channels=\"").append(this.payload.getChannels()).append("\"");
                }
                if (this.getChildAttributes() != null) {
                    buf.append(this.getChildAttributes());
                }
                buf.append("/>");
            }
            return buf.toString();
        }

        public static class Audio
        extends JinglePayloadType {
            public Audio(PayloadType.Audio audio) {
                super(audio);
            }

            protected String getChildAttributes() {
                StringBuilder buf = new StringBuilder();
                PayloadType pt = this.getPayloadType();
                if (pt instanceof PayloadType.Audio) {
                    PayloadType.Audio pta = (PayloadType.Audio)pt;
                    buf.append(" clockrate=\"").append(pta.getClockRate()).append("\" ");
                }
                return buf.toString();
            }
        }
    }

    public static class Audio
    extends JingleContentDescription {
        public static final String NAMESPACE = "urn:xmpp:tmp:jingle:apps:rtp";

        public Audio() {
        }

        public Audio(JinglePayloadType pt) {
            this.addJinglePayloadType(pt);
        }

        public String getNamespace() {
            return NAMESPACE;
        }
    }
}

