/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.packet.AdHocCommandData;

public class RemoteCommand
extends AdHocCommand {
    private Connection connection;
    private String jid;
    private String sessionID;
    private long packetReplyTimeout;

    protected RemoteCommand(Connection connection, String string, String string2) {
        this.connection = connection;
        this.jid = string2;
        this.setNode(string);
        this.packetReplyTimeout = SmackConfiguration.getPacketReplyTimeout();
    }

    @Override
    public void cancel() throws XMPPException {
        this.executeAction(AdHocCommand.Action.cancel, this.packetReplyTimeout);
    }

    @Override
    public void complete(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.complete, form, this.packetReplyTimeout);
    }

    @Override
    public void execute() throws XMPPException {
        this.executeAction(AdHocCommand.Action.execute, this.packetReplyTimeout);
    }

    public void execute(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.execute, form, this.packetReplyTimeout);
    }

    @Override
    public void next(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.next, form, this.packetReplyTimeout);
    }

    @Override
    public void prev() throws XMPPException {
        this.executeAction(AdHocCommand.Action.prev, this.packetReplyTimeout);
    }

    private void executeAction(AdHocCommand.Action action, long l) throws XMPPException {
        this.executeAction(action, null, l);
    }

    private void executeAction(AdHocCommand.Action action, Form form, long l) throws XMPPException {
        AdHocCommandData adHocCommandData = new AdHocCommandData();
        adHocCommandData.setType(IQ.Type.SET);
        adHocCommandData.setTo(this.getOwnerJID());
        adHocCommandData.setNode(this.getNode());
        adHocCommandData.setSessionID(this.sessionID);
        adHocCommandData.setAction(action);
        if (form != null) {
            adHocCommandData.setForm(form.getDataFormToSend());
        }
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(adHocCommandData.getPacketID()));
        this.connection.sendPacket(adHocCommandData);
        Packet packet = packetCollector.nextResult(l);
        packetCollector.cancel();
        if (packet == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (packet.getError() != null) {
            throw new XMPPException(packet.getError());
        }
        AdHocCommandData adHocCommandData2 = (AdHocCommandData)packet;
        this.sessionID = adHocCommandData2.getSessionID();
        super.setData(adHocCommandData2);
    }

    @Override
    public String getOwnerJID() {
        return this.jid;
    }

    public long getPacketReplyTimeout() {
        return this.packetReplyTimeout;
    }

    public void setPacketReplyTimeout(long l) {
        this.packetReplyTimeout = l;
    }
}

