/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Date;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.workgroup.agent.AgentSession;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;

public class Offer {
    private Connection connection;
    private AgentSession session;
    private String sessionID;
    private String userJID;
    private String userID;
    private String workgroupName;
    private Date expiresDate;
    private Map metaData;
    private OfferContent content;
    private boolean accepted = false;
    private boolean rejected = false;

    Offer(Connection connection, AgentSession agentSession, String string, String string2, String string3, Date date, String string4, Map map, OfferContent offerContent) {
        this.connection = connection;
        this.session = agentSession;
        this.userID = string;
        this.userJID = string2;
        this.workgroupName = string3;
        this.expiresDate = date;
        this.sessionID = string4;
        this.metaData = map;
        this.content = offerContent;
    }

    public void accept() {
        AcceptPacket acceptPacket = new AcceptPacket(this.session.getWorkgroupJID());
        this.connection.sendPacket(acceptPacket);
        this.accepted = true;
    }

    public void reject() {
        RejectPacket rejectPacket = new RejectPacket(this.session.getWorkgroupJID());
        this.connection.sendPacket(rejectPacket);
        this.rejected = true;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getUserJID() {
        return this.userJID;
    }

    public String getWorkgroupName() {
        return this.workgroupName;
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public Map getMetaData() {
        return this.metaData;
    }

    public OfferContent getContent() {
        return this.content;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    private class AcceptPacket
    extends IQ {
        AcceptPacket(String string) {
            this.setTo(string);
            this.setType(IQ.Type.SET);
        }

        @Override
        public String getChildElementXML() {
            return "<offer-accept id=\"" + Offer.this.getSessionID() + "\" xmlns=\"http://jabber.org/protocol/workgroup" + "\"/>";
        }
    }

    private class RejectPacket
    extends IQ {
        RejectPacket(String string) {
            this.setTo(string);
            this.setType(IQ.Type.SET);
        }

        @Override
        public String getChildElementXML() {
            return "<offer-reject id=\"" + Offer.this.getSessionID() + "\" xmlns=\"http://jabber.org/protocol/workgroup" + "\"/>";
        }
    }
}

