/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.bookmark.BookmarkedConference;
import org.jivesoftware.smackx.bookmark.BookmarkedURL;
import org.jivesoftware.smackx.bookmark.SharedBookmark;
import org.jivesoftware.smackx.packet.PrivateData;
import org.jivesoftware.smackx.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bookmarks
implements PrivateData {
    private List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return "storage";
    }

    @Override
    public String getNamespace() {
        return "storage:bookmarks";
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<storage xmlns=\"storage:bookmarks\">");
        for (BookmarkedURL object : this.getBookmarkedURLS()) {
            if (object.isShared()) continue;
            stringBuilder.append("<url name=\"").append(object.getName()).append("\" url=\"").append(object.getURL()).append("\"");
            if (object.isRss()) {
                stringBuilder.append(" rss=\"").append(true).append("\"");
            }
            stringBuilder.append(" />");
        }
        for (BookmarkedConference bookmarkedConference : this.getBookmarkedConferences()) {
            if (bookmarkedConference.isShared()) continue;
            stringBuilder.append("<conference ");
            stringBuilder.append("name=\"").append(bookmarkedConference.getName()).append("\" ");
            stringBuilder.append("autojoin=\"").append(bookmarkedConference.isAutoJoin()).append("\" ");
            stringBuilder.append("jid=\"").append(bookmarkedConference.getJid()).append("\" ");
            stringBuilder.append(">");
            if (bookmarkedConference.getNickname() != null) {
                stringBuilder.append("<nick>").append(bookmarkedConference.getNickname()).append("</nick>");
            }
            if (bookmarkedConference.getPassword() != null) {
                stringBuilder.append("<password>").append(bookmarkedConference.getPassword()).append("</password>");
            }
            stringBuilder.append("</conference>");
        }
        stringBuilder.append("</storage>");
        return stringBuilder.toString();
    }

    private static BookmarkedURL getURLStorage(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        String string = xmlPullParser.getAttributeValue("", "name");
        String string2 = xmlPullParser.getAttributeValue("", "url");
        String string3 = xmlPullParser.getAttributeValue("", "rss");
        boolean bl = string3 != null && "true".equals(string3);
        BookmarkedURL bookmarkedURL = new BookmarkedURL(string2, string, bl);
        boolean bl2 = false;
        while (!bl2) {
            int n = xmlPullParser.next();
            if (n == 2 && "shared_bookmark".equals(xmlPullParser.getName())) {
                bookmarkedURL.setShared(true);
                continue;
            }
            if (n != 3 || !"url".equals(xmlPullParser.getName())) continue;
            bl2 = true;
        }
        return bookmarkedURL;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue("", "name");
        String string2 = xmlPullParser.getAttributeValue("", "autojoin");
        String string3 = xmlPullParser.getAttributeValue("", "jid");
        BookmarkedConference bookmarkedConference = new BookmarkedConference(string3);
        bookmarkedConference.setName(string);
        bookmarkedConference.setAutoJoin(Boolean.valueOf(string2));
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2 && "nick".equals(xmlPullParser.getName())) {
                bookmarkedConference.setNickname(xmlPullParser.nextText());
                continue;
            }
            if (n == 2 && "password".equals(xmlPullParser.getName())) {
                bookmarkedConference.setPassword(xmlPullParser.nextText());
                continue;
            }
            if (n == 2 && "shared_bookmark".equals(xmlPullParser.getName())) {
                bookmarkedConference.setShared(true);
                continue;
            }
            if (n != 3 || !"conference".equals(xmlPullParser.getName())) continue;
            bl = true;
        }
        return bookmarkedConference;
    }

    public static class Provider
    implements PrivateDataProvider {
        public PrivateData parsePrivateData(XmlPullParser xmlPullParser) throws Exception {
            Bookmarks bookmarks = new Bookmarks();
            boolean bl = false;
            while (!bl) {
                SharedBookmark sharedBookmark;
                int n = xmlPullParser.next();
                if (n == 2 && "url".equals(xmlPullParser.getName())) {
                    sharedBookmark = Bookmarks.getURLStorage(xmlPullParser);
                    if (sharedBookmark == null) continue;
                    bookmarks.addBookmarkedURL((BookmarkedURL)sharedBookmark);
                    continue;
                }
                if (n == 2 && "conference".equals(xmlPullParser.getName())) {
                    sharedBookmark = Bookmarks.getConferenceStorage(xmlPullParser);
                    bookmarks.addBookmarkedConference((BookmarkedConference)sharedBookmark);
                    continue;
                }
                if (n != 3 || !"storage".equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return bookmarks;
        }
    }
}

