/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPacketExtension
implements PacketExtension {
    private String elementName;
    private String namespace;
    private Map<String, String> map;

    public DefaultPacketExtension(String string, String string2) {
        this.elementName = string;
        this.namespace = string2;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.elementName).append(" xmlns=\"").append(this.namespace).append("\">");
        for (String string : this.getNames()) {
            String string2 = this.getValue(string);
            stringBuilder.append("<").append(string).append(">");
            stringBuilder.append(string2);
            stringBuilder.append("</").append(string).append(">");
        }
        stringBuilder.append("</").append(this.elementName).append(">");
        return stringBuilder.toString();
    }

    public synchronized Collection<String> getNames() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashMap<String, String>(this.map).keySet());
    }

    public synchronized String getValue(String string) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(string);
    }

    public synchronized void setValue(String string, String string2) {
        if (this.map == null) {
            this.map = new HashMap<String, String>();
        }
        this.map.put(string, string2);
    }
}

