/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

abstract class U16NameBase
extends Record {
    private static final long serialVersionUID = -8315884183112502995L;
    protected int u16Field;
    protected Name nameField;

    protected U16NameBase() {
    }

    protected U16NameBase(Name name, int n, int n2, long l) {
        super(name, n, n2, l);
    }

    protected U16NameBase(Name name, int n, int n2, long l, int n3, String string, Name name2, String string2) {
        super(name, n, n2, l);
        this.u16Field = U16NameBase.checkU16(string, n3);
        this.nameField = U16NameBase.checkName(string2, name2);
    }

    @Override
    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.u16Field = dNSInput.readU16();
        this.nameField = new Name(dNSInput);
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.u16Field = tokenizer.getUInt16();
        this.nameField = tokenizer.getName(name);
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.u16Field);
        stringBuffer.append(" ");
        stringBuffer.append(this.nameField);
        return stringBuffer.toString();
    }

    protected int getU16Field() {
        return this.u16Field;
    }

    protected Name getNameField() {
        return this.nameField;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.u16Field);
        this.nameField.toWire(dNSOutput, null, bl);
    }
}

