/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.Map;
import org.jivesoftware.smack.util.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class DNSUtil {
    private static Map<String, HostAddress> ccache = new Cache<String, HostAddress>(100, 600000L);
    private static Map<String, HostAddress> scache = new Cache<String, HostAddress>(100, 600000L);

    private static HostAddress resolveSRV(String string) {
        String string2 = null;
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        try {
            Lookup lookup = new Lookup(string, 33);
            Record[] recordArray = lookup.run();
            if (recordArray == null) {
                return null;
            }
            for (Record record : recordArray) {
                SRVRecord sRVRecord = (SRVRecord)record;
                if (sRVRecord == null || sRVRecord.getTarget() == null) continue;
                int n4 = (int)((double)(sRVRecord.getWeight() * sRVRecord.getWeight()) * Math.random());
                if (sRVRecord.getPriority() < n2) {
                    n2 = sRVRecord.getPriority();
                    n3 = n4;
                    string2 = sRVRecord.getTarget().toString();
                    n = sRVRecord.getPort();
                    continue;
                }
                if (sRVRecord.getPriority() != n2 || n4 <= n3) continue;
                n2 = sRVRecord.getPriority();
                n3 = n4;
                string2 = sRVRecord.getTarget().toString();
                n = sRVRecord.getPort();
            }
        }
        catch (TextParseException textParseException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null) {
            return null;
        }
        if (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return new HostAddress(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostAddress resolveXMPPDomain(String string) {
        Object object;
        Object object2 = ccache;
        synchronized (object2) {
            if (ccache.containsKey(string) && (object = ccache.get(string)) != null) {
                return object;
            }
        }
        object2 = DNSUtil.resolveSRV("_xmpp-client._tcp." + string);
        if (object2 == null) {
            object2 = DNSUtil.resolveSRV("_jabber._tcp." + string);
        }
        if (object2 == null) {
            object2 = new HostAddress(string, 5222);
        }
        object = ccache;
        synchronized (object) {
            ccache.put(string, (HostAddress)object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostAddress resolveXMPPServerDomain(String string) {
        Object object;
        Object object2 = scache;
        synchronized (object2) {
            if (scache.containsKey(string) && (object = scache.get(string)) != null) {
                return object;
            }
        }
        object2 = DNSUtil.resolveSRV("_xmpp-server._tcp." + string);
        if (object2 == null) {
            object2 = DNSUtil.resolveSRV("_jabber._tcp." + string);
        }
        if (object2 == null) {
            object2 = new HostAddress(string, 5269);
        }
        object = scache;
        synchronized (object) {
            scache.put(string, (HostAddress)object2);
        }
        return object2;
    }

    public static class HostAddress {
        private String host;
        private int port;

        private HostAddress(String string, int n) {
            this.host = string;
            this.port = n;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HostAddress)) {
                return false;
            }
            HostAddress hostAddress = (HostAddress)object;
            if (!this.host.equals(hostAddress.host)) {
                return false;
            }
            return this.port == hostAddress.port;
        }
    }
}

