/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.jmf;

import java.io.IOException;
import java.net.ServerSocket;
import javax.media.Format;
import javax.media.MediaLocator;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.mediaimpl.jmf.AudioChannel;
import org.jivesoftware.smackx.jingle.mediaimpl.jmf.AudioFormatUtils;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

public class AudioMediaSession
extends JingleMediaSession {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(AudioMediaSession.class);
    private AudioChannel audioChannel;

    public AudioMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, String locator, JingleSession jingleSession) {
        super(payloadType, remote, local, locator == null ? "dsound://" : locator, jingleSession);
        this.initialize();
    }

    public void initialize() {
        int remotePort;
        int localPort;
        String localIp;
        String ip;
        if (this.getLocal().getSymmetric() != null) {
            ip = this.getLocal().getIp();
            localIp = this.getLocal().getLocalIp();
            localPort = this.getFreePort();
            remotePort = this.getLocal().getSymmetric().getPort();
            LOGGER.debug(this.getLocal().getConnection() + " " + ip + ": " + localPort + "->" + remotePort);
        } else {
            ip = this.getRemote().getIp();
            localIp = this.getLocal().getLocalIp();
            localPort = this.getLocal().getPort();
            remotePort = this.getRemote().getPort();
        }
        this.audioChannel = new AudioChannel(new MediaLocator(this.getMediaLocator()), localIp, ip, localPort, remotePort, (Format)AudioFormatUtils.getAudioFormat(this.getPayloadType()), this);
    }

    public void startTrasmit() {
        this.audioChannel.start();
    }

    public void setTrasmit(boolean active) {
        this.audioChannel.setTrasmit(active);
    }

    public void startReceive() {
    }

    public void stopTrasmit() {
        if (this.audioChannel != null) {
            this.audioChannel.stop();
        }
    }

    public void stopReceive() {
    }

    protected int getFreePort() {
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)(10000L + Math.round(Math.random() * 10000.0));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ServerSocket ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                return freePort;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return freePort;
    }
}

