/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiatorManager;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.Bytestream;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    protected static final String NAMESPACE = "http://jabber.org/protocol/bytestreams";
    private static final int CONNECT_FAILURE_THRESHOLD = 2;
    public static boolean isAllowLocalProxyHost = true;
    private final XMPPConnection connection;
    private Socks5TransferNegotiatorManager transferNegotiatorManager;

    public Socks5TransferNegotiator(Socks5TransferNegotiatorManager socks5TransferNegotiatorManager, XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.transferNegotiatorManager = socks5TransferNegotiatorManager;
    }

    public PacketFilter getInitiationPacketFilter(String string, String string2) {
        return new AndFilter(new FromMatchesFilter(string), new BytestreamSIDFilter(string2));
    }

    InputStream negotiateIncomingStream(Packet packet) throws XMPPException {
        SelectedHostInfo selectedHostInfo;
        Bytestream bytestream = (Bytestream)packet;
        if (bytestream.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException(bytestream.getError());
        }
        try {
            selectedHostInfo = this.selectHost(bytestream);
        }
        catch (XMPPException xMPPException) {
            if (xMPPException.getXMPPError() != null) {
                IQ iQ = super.createError(bytestream.getTo(), bytestream.getFrom(), bytestream.getPacketID(), xMPPException.getXMPPError());
                this.connection.sendPacket(iQ);
            }
            throw xMPPException;
        }
        Bytestream bytestream2 = this.createUsedHostConfirmation(selectedHostInfo.selectedHost, bytestream.getFrom(), bytestream.getTo(), bytestream.getPacketID());
        this.connection.sendPacket(bytestream2);
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(selectedHostInfo.establishedSocket.getInputStream());
            int n = pushbackInputStream.read();
            pushbackInputStream.unread(n);
            return pushbackInputStream;
        }
        catch (IOException iOException) {
            throw new XMPPException("Error establishing input stream", iOException);
        }
    }

    public InputStream createIncomingStream(StreamInitiation streamInitiation) throws XMPPException {
        Packet packet = this.initiateIncomingStream(this.connection, streamInitiation);
        return this.negotiateIncomingStream(packet);
    }

    private Bytestream createUsedHostConfirmation(Bytestream.StreamHost streamHost, String string, String string2, String string3) {
        Bytestream bytestream = new Bytestream();
        bytestream.setTo(string);
        bytestream.setFrom(string2);
        bytestream.setType(IQ.Type.RESULT);
        bytestream.setPacketID(string3);
        bytestream.setUsedHost(streamHost.getJID());
        return bytestream;
    }

    private SelectedHostInfo selectHost(Bytestream bytestream) throws XMPPException {
        String string;
        Iterator<Bytestream.StreamHost> iterator = bytestream.getStreamHosts().iterator();
        Bytestream.StreamHost streamHost = null;
        Socket socket = null;
        while (iterator.hasNext()) {
            streamHost = iterator.next();
            string = streamHost.getAddress();
            int n = this.getConnectionFailures(string);
            if (n >= 2) continue;
            try {
                socket = new Socket(string, streamHost.getPort());
                this.establishSOCKS5ConnectionToProxy(socket, this.createDigest(bytestream.getSessionID(), bytestream.getFrom(), bytestream.getTo()));
                break;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.incrementConnectionFailures(string);
                streamHost = null;
                socket = null;
            }
        }
        if (streamHost == null || socket == null || !socket.isConnected()) {
            string = "Could not establish socket with any provided host";
            throw new XMPPException(string, new XMPPError(XMPPError.Condition.no_acceptable, string));
        }
        return new SelectedHostInfo(streamHost, socket);
    }

    private void incrementConnectionFailures(String string) {
        this.transferNegotiatorManager.incrementConnectionFailures(string);
    }

    private int getConnectionFailures(String string) {
        return this.transferNegotiatorManager.getConnectionFailures(string);
    }

    private String createDigest(String string, String string2, String string3) {
        return StringUtils.hash(string + StringUtils.parseName(string2) + "@" + StringUtils.parseServer(string2) + "/" + StringUtils.parseResource(string2) + StringUtils.parseName(string3) + "@" + StringUtils.parseServer(string3) + "/" + StringUtils.parseResource(string3));
    }

    public OutputStream createOutgoingStream(String string, String string2, String string3) throws XMPPException {
        Socket socket;
        try {
            socket = this.initBytestreamSocket(string, string2, string3);
        }
        catch (Exception exception) {
            throw new XMPPException("Error establishing transfer socket", exception);
        }
        if (socket != null) {
            try {
                return new BufferedOutputStream(socket.getOutputStream());
            }
            catch (IOException iOException) {
                throw new XMPPException("Error establishing output stream", iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket initBytestreamSocket(String string, String string2, String string3) throws Exception {
        Socket socket;
        Socks5TransferNegotiatorManager.ProxyProcess proxyProcess;
        try {
            proxyProcess = this.establishListeningSocket();
        }
        catch (IOException iOException) {
            proxyProcess = null;
        }
        try {
            String string4;
            try {
                string4 = this.discoverLocalIP();
            }
            catch (UnknownHostException unknownHostException) {
                string4 = null;
            }
            Bytestream bytestream = this.createByteStreamInit(string2, string3, string, string4, proxyProcess != null ? proxyProcess.getPort() : 0);
            socket = this.waitForUsedHostResponse((String)string, (Socks5TransferNegotiatorManager.ProxyProcess)proxyProcess, (String)this.createDigest((String)string, (String)string2, (String)string3), (Bytestream)bytestream).establishedSocket;
        }
        finally {
            this.cleanupListeningSocket();
        }
        return socket;
    }

    private SelectedHostInfo waitForUsedHostResponse(String string, Socks5TransferNegotiatorManager.ProxyProcess proxyProcess, String string2, Bytestream bytestream) throws XMPPException, IOException {
        SelectedHostInfo selectedHostInfo = new SelectedHostInfo();
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(bytestream.getPacketID()));
        this.connection.sendPacket(bytestream);
        Packet packet = packetCollector.nextResult(10000L);
        packetCollector.cancel();
        if (packet == null || !(packet instanceof Bytestream)) {
            throw new XMPPException("Unexpected response from remote user");
        }
        Bytestream bytestream2 = (Bytestream)packet;
        if (bytestream2.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException("Remote client returned error, stream hosts expected", bytestream2.getError());
        }
        Bytestream.StreamHostUsed streamHostUsed = bytestream2.getUsedHost();
        Bytestream.StreamHost streamHost = bytestream.getStreamHost(streamHostUsed.getJID());
        if (streamHost == null) {
            throw new XMPPException("Remote user responded with unknown host");
        }
        if (streamHostUsed.getJID().equals(bytestream.getFrom())) {
            selectedHostInfo.establishedSocket = proxyProcess.getSocket(string2);
            selectedHostInfo.selectedHost = streamHost;
            return selectedHostInfo;
        }
        selectedHostInfo.establishedSocket = new Socket(streamHost.getAddress(), streamHost.getPort());
        this.establishSOCKS5ConnectionToProxy(selectedHostInfo.establishedSocket, string2);
        Bytestream bytestream3 = Socks5TransferNegotiator.createByteStreamActivate(string, bytestream2.getTo(), streamHost.getJID(), bytestream2.getFrom());
        packetCollector = this.connection.createPacketCollector(new PacketIDFilter(bytestream3.getPacketID()));
        this.connection.sendPacket(bytestream3);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (!iQ.getType().equals(IQ.Type.RESULT)) {
            selectedHostInfo.establishedSocket.close();
            return null;
        }
        return selectedHostInfo;
    }

    private Socks5TransferNegotiatorManager.ProxyProcess establishListeningSocket() throws IOException {
        return this.transferNegotiatorManager.addTransfer();
    }

    private void cleanupListeningSocket() {
        this.transferNegotiatorManager.removeTransfer();
    }

    private String discoverLocalIP() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private Bytestream createByteStreamInit(String string, String string2, String string3, String string4, int n) {
        Collection<Bytestream.StreamHost> collection;
        Bytestream bytestream = new Bytestream();
        bytestream.setTo(string2);
        bytestream.setFrom(string);
        bytestream.setSessionID(string3);
        bytestream.setType(IQ.Type.SET);
        bytestream.setMode(Bytestream.Mode.tcp);
        if (string4 != null && n > 0) {
            bytestream.addStreamHost(string, string4, n);
        }
        if ((collection = this.transferNegotiatorManager.getStreamHosts()) != null) {
            for (Bytestream.StreamHost streamHost : collection) {
                bytestream.addStreamHost(streamHost);
            }
        }
        return bytestream;
    }

    private static Bytestream createByteStreamActivate(String string, String string2, String string3, String string4) {
        Bytestream bytestream = new Bytestream(string);
        bytestream.setMode(null);
        bytestream.setToActivate(string4);
        bytestream.setFrom(string2);
        bytestream.setTo(string3);
        bytestream.setType(IQ.Type.SET);
        return bytestream;
    }

    public String[] getNamespaces() {
        return new String[]{NAMESPACE};
    }

    private void establishSOCKS5ConnectionToProxy(Socket socket, String string) throws IOException {
        byte[] byArray = new byte[]{5, 1, 0};
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        ((OutputStream)dataOutputStream).write(byArray);
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        byte[] byArray2 = new byte[2];
        ((InputStream)dataInputStream).read(byArray2);
        byArray = Socks5TransferNegotiator.createOutgoingSocks5Message(1, string);
        ((OutputStream)dataOutputStream).write(byArray);
        Socks5TransferNegotiator.createIncomingSocks5Message(dataInputStream);
    }

    static String createIncomingSocks5Message(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[5];
        inputStream.read(byArray, 0, 5);
        byte[] byArray2 = new byte[byArray[4]];
        inputStream.read(byArray2, 0, byArray2.length);
        String string = new String(byArray2);
        inputStream.read();
        inputStream.read();
        return string;
    }

    static byte[] createOutgoingSocks5Message(int n, String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[7 + byArray.length];
        byArray2[0] = 5;
        byArray2[1] = (byte)n;
        byArray2[2] = 0;
        byArray2[3] = 3;
        byArray2[4] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[byArray2.length - 2] = 0;
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    public void cleanup() {
    }

    private static class BytestreamSIDFilter
    implements PacketFilter {
        private String sessionID;

        public BytestreamSIDFilter(String string) {
            if (string == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = string;
        }

        public boolean accept(Packet packet) {
            if (!Bytestream.class.isInstance(packet)) {
                return false;
            }
            Bytestream bytestream = (Bytestream)packet;
            String string = bytestream.getSessionID();
            return string != null && string.equals(this.sessionID);
        }
    }

    private static class SelectedHostInfo {
        protected XMPPException exception;
        protected Bytestream.StreamHost selectedHost;
        protected Socket establishedSocket;

        SelectedHostInfo(Bytestream.StreamHost streamHost, Socket socket) {
            this.selectedHost = streamHost;
            this.establishedSocket = socket;
        }

        public SelectedHostInfo() {
        }
    }
}

