/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.sasl.SASLAnonymous;
import org.jivesoftware.smack.sasl.SASLCramMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLDigestMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLExternalMechanism;
import org.jivesoftware.smack.sasl.SASLGSSAPIMechanism;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.SASLPlainMechanism;

public class SASLAuthentication
implements UserAuthentication {
    private static Map<String, Class> implementedMechanisms = new HashMap<String, Class>();
    private static List<String> mechanismsPreferences = new ArrayList<String>();
    private Connection connection;
    private Collection<String> serverMechanisms = new ArrayList<String>();
    private SASLMechanism currentMechanism = null;
    private boolean saslNegotiated;
    private boolean saslFailed;
    private boolean resourceBinded;
    private boolean sessionSupported;
    private String errorCondition;

    public static void registerSASLMechanism(String string, Class clazz) {
        implementedMechanisms.put(string, clazz);
    }

    public static void unregisterSASLMechanism(String string) {
        implementedMechanisms.remove(string);
        mechanismsPreferences.remove(string);
    }

    public static void supportSASLMechanism(String string) {
        mechanismsPreferences.add(0, string);
    }

    public static void supportSASLMechanism(String string, int n) {
        mechanismsPreferences.add(n, string);
    }

    public static void unsupportSASLMechanism(String string) {
        mechanismsPreferences.remove(string);
    }

    public static List<Class> getRegisterSASLMechanisms() {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (String string : mechanismsPreferences) {
            arrayList.add(implementedMechanisms.get(string));
        }
        return arrayList;
    }

    SASLAuthentication(Connection connection) {
        this.connection = connection;
        this.init();
    }

    public boolean hasAnonymousAuthentication() {
        return this.serverMechanisms.contains("ANONYMOUS");
    }

    public boolean hasNonAnonymousAuthentication() {
        return !this.serverMechanisms.isEmpty() && (this.serverMechanisms.size() != 1 || !this.hasAnonymousAuthentication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String authenticate(String string, String string2, CallbackHandler callbackHandler) throws XMPPException {
        String string3 = null;
        for (String string4 : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(string4) || !this.serverMechanisms.contains(string4)) continue;
            string3 = string4;
            break;
        }
        if (string3 == null) throw new XMPPException("SASL Authentication failed. No known authentication mechanisims.");
        try {
            Class clazz = implementedMechanisms.get(string3);
            Constructor constructor = clazz.getConstructor(SASLAuthentication.class);
            this.currentMechanism = (SASLMechanism)constructor.newInstance(this);
            this.currentMechanism.authenticate(string, this.connection.getHost(), callbackHandler);
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                if (!this.saslNegotiated && !this.saslFailed) {
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.saslFailed) {
                if (this.errorCondition == null) throw new XMPPException("SASL authentication failed using mechanism " + string3);
                throw new XMPPException("SASL authentication " + string3 + " failed: " + this.errorCondition);
            }
            if (!this.saslNegotiated) throw new XMPPException("SASL authentication failed");
            return this.bindResourceAndEstablishSession(string2);
        }
        catch (XMPPException xMPPException) {
            throw xMPPException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new XMPPException("SASL authentication failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(String string, String string2, String string3) throws XMPPException {
        String string4 = null;
        for (String object : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(object) || !this.serverMechanisms.contains(object)) continue;
            string4 = object;
            break;
        }
        if (string4 != null) {
            try {
                Class clazz = implementedMechanisms.get(string4);
                Constructor constructor = clazz.getConstructor(SASLAuthentication.class);
                this.currentMechanism = (SASLMechanism)constructor.newInstance(this);
                this.currentMechanism.authenticate(string, this.connection.getServiceName(), string2);
                SASLAuthentication sASLAuthentication = this;
                synchronized (sASLAuthentication) {
                    if (!this.saslNegotiated && !this.saslFailed) {
                        try {
                            this.wait(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.saslFailed) {
                    if (this.errorCondition != null) {
                        throw new XMPPException("SASL authentication " + string4 + " failed: " + this.errorCondition);
                    }
                    throw new XMPPException("SASL authentication failed using mechanism " + string4);
                }
                if (this.saslNegotiated) {
                    return this.bindResourceAndEstablishSession(string3);
                }
                return new NonSASLAuthentication(this.connection).authenticate(string, string2, string3);
            }
            catch (XMPPException xMPPException) {
                throw xMPPException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new NonSASLAuthentication(this.connection).authenticate(string, string2, string3);
            }
        }
        return new NonSASLAuthentication(this.connection).authenticate(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticateAnonymously() throws XMPPException {
        try {
            this.currentMechanism = new SASLAnonymous(this);
            this.currentMechanism.authenticate(null, null, "");
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                if (!this.saslNegotiated && !this.saslFailed) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.saslFailed) {
                if (this.errorCondition != null) {
                    throw new XMPPException("SASL authentication failed: " + this.errorCondition);
                }
                throw new XMPPException("SASL authentication failed");
            }
            if (this.saslNegotiated) {
                return this.bindResourceAndEstablishSession(null);
            }
            return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        }
        catch (IOException iOException) {
            return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String bindResourceAndEstablishSession(String string) throws XMPPException {
        Object object = this;
        synchronized (object) {
            if (!this.resourceBinded) {
                try {
                    this.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.resourceBinded) {
            throw new XMPPException("Resource binding not offered by server");
        }
        object = new Bind();
        ((Bind)object).setResource(string);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(((Packet)object).getPacketID()));
        this.connection.sendPacket((Packet)object);
        Bind bind = (Bind)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (bind == null) {
            throw new XMPPException("No response from the server.");
        }
        if (bind.getType() == IQ.Type.ERROR) {
            throw new XMPPException(bind.getError());
        }
        String string2 = bind.getJid();
        if (this.sessionSupported) {
            Session session = new Session();
            packetCollector = this.connection.createPacketCollector(new PacketIDFilter(session.getPacketID()));
            this.connection.sendPacket(session);
            IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            packetCollector.cancel();
            if (iQ == null) {
                throw new XMPPException("No response from the server.");
            }
            if (iQ.getType() == IQ.Type.ERROR) {
                throw new XMPPException(iQ.getError());
            }
        } else {
            throw new XMPPException("Session establishment not offered by server");
        }
        return string2;
    }

    void setAvailableSASLMethods(Collection<String> collection) {
        this.serverMechanisms = collection;
    }

    public boolean isAuthenticated() {
        return this.saslNegotiated;
    }

    void challengeReceived(String string) throws IOException {
        this.currentMechanism.challengeReceived(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticated() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.saslNegotiated = true;
            this.notify();
        }
    }

    void authenticationFailed() {
        this.authenticationFailed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed(String string) {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.saslFailed = true;
            this.errorCondition = string;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindingRequired() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.resourceBinded = true;
            this.notify();
        }
    }

    public void send(Packet packet) {
        this.connection.sendPacket(packet);
    }

    void sessionsSupported() {
        this.sessionSupported = true;
    }

    protected void init() {
        this.saslNegotiated = false;
        this.saslFailed = false;
        this.resourceBinded = false;
        this.sessionSupported = false;
    }

    static {
        SASLAuthentication.registerSASLMechanism("EXTERNAL", SASLExternalMechanism.class);
        SASLAuthentication.registerSASLMechanism("GSSAPI", SASLGSSAPIMechanism.class);
        SASLAuthentication.registerSASLMechanism("DIGEST-MD5", SASLDigestMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("CRAM-MD5", SASLCramMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("PLAIN", SASLPlainMechanism.class);
        SASLAuthentication.registerSASLMechanism("ANONYMOUS", SASLAnonymous.class);
        SASLAuthentication.supportSASLMechanism("DIGEST-MD5", 0);
        SASLAuthentication.supportSASLMechanism("PLAIN", 1);
        SASLAuthentication.supportSASLMechanism("ANONYMOUS", 2);
    }
}

