package com.beem.project.beem.jingle;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/**
 * RTPMediaManager, gere les payloads et renvoie une session RTP.
 * 
 * @author nikita
 */
public class MicrophoneRTPManager extends JingleMediaManager {
	/**
	 * RTP media name.
	 */
	public static final String MEDIA_NAME = "Microphone";

	private List<PayloadType> mPayloads;

	/**
	 * Manage Microphone data transmission trough RTP.
	 * 
	 * @param transportManager
	 *            current jingle transport manager(basic,upnp,ice...).
	 */
	public MicrophoneRTPManager(final JingleTransportManager transportManager) {
		super(transportManager);
		// TODO Auto-generated constructor stub
		setupPayloads();
	}

	@Override
	public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote,
			TransportCandidate local, JingleSession jingleSession) {
		// TODO Auto-generated method stub
		return new MicrophoneRTPSession(payloadType, remote, local, null, jingleSession);
	}

	@Override
	public String getName() {
		return MEDIA_NAME;
	}

	@Override
	public List<PayloadType> getPayloads() {
		// TODO Auto-generated method stub
		return mPayloads;
	}

	/**
	 * Supported payload list.
	 */
	private void setupPayloads() {
		mPayloads = new ArrayList<PayloadType>();
		mPayloads.add(new PayloadType.Audio(0, "PCMU"));
		mPayloads.add(new PayloadType.Audio(8, "PCMA"));
	}
}
