
package com.beem.project.beem.smack;

import java.util.List;
import java.util.LinkedList;
import org.jivesoftware.smack.packet.PacketExtension;

public class AvatarMetadataExtension implements PacketExtension {
    List<Info> infos = new LinkedList<Info>();

    public AvatarMetadataExtension() {
    }

    public List<Info> getInfos() {
	return infos;
    }

    public void addInfo(Info info) {
	infos.add(info);
    }

    @Override
    public String getElementName() {
	return "metadata";
    }

    @Override
    public String getNamespace() {
	return "urn:xmpp:avatar:metadata";
    }

//     @Override
    protected String getNode() {
	return "urn:xmpp:avatar:metadata";
    }

//     @Override
    protected String getItemDetailsXML() {
	StringBuilder builder = new StringBuilder("<metadata xmlns=\"");
	builder.append(getNode()).append("\">");
	for (Info info : infos) {
	    builder.append(info.toXML());
	}
	builder.append("</metadata>");

	return builder.toString();
    }

    @Override
    public String toXML() {
	return getItemDetailsXML();
    }

    public static class Info {
	 public int bytes;
	 public int height;
	 public String id;
	 public String type;
	 private String url;
	 public int width;

	 public void setUrl(String url) {
	    this.url = url;
	 }

	 public String getUrl() {
	    return url;
	 }

	 public String getId() {
	    return id;
	 }

	 public String toXML() {
	     StringBuilder builder = new StringBuilder("<info ");
	     builder.append("bytes=\"" + bytes + "\"");
	     builder.append(" id=\"" + id + "\"");
	     builder.append(" type=\"" + type + "\"");

	     if (height > 0)
		 builder.append(" height=\"" + height + "\"");
	     if (width > 0)
		 builder.append(" width=\"" + width + "\"");
	     if (url != null)
		 builder.append(" url=\"" + url + "\"");
	     builder.append(" />");
	     return builder.toString();
	 }
    }
}
