/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class ItemsExtension
extends NodeExtension
implements EmbeddedPacketExtension {
    protected ItemsElementType type;
    protected Boolean notify;
    protected List<? extends PacketExtension> items;

    public ItemsExtension(ItemsElementType itemsElementType, String string, List<? extends PacketExtension> list) {
        super(itemsElementType.getNodeElement(), string);
        this.type = itemsElementType;
        this.items = list;
    }

    public ItemsExtension(String string, List<? extends PacketExtension> list, boolean bl) {
        super(ItemsElementType.retract.getNodeElement(), string);
        this.type = ItemsElementType.retract;
        this.items = list;
        this.notify = bl;
    }

    public ItemsElementType getItemsElementType() {
        return this.type;
    }

    @Override
    public List<PacketExtension> getExtensions() {
        return this.getItems();
    }

    public List<? extends PacketExtension> getItems() {
        return this.items;
    }

    public boolean getNotify() {
        return this.notify;
    }

    @Override
    public String toXML() {
        if (this.items == null || this.items.size() == 0) {
            return super.toXML();
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(" node='");
        stringBuilder.append(this.getNode());
        if (this.notify != null) {
            stringBuilder.append("' ");
            stringBuilder.append(this.type.getElementAttribute());
            stringBuilder.append("='");
            stringBuilder.append(this.notify.equals(Boolean.TRUE) ? 1 : 0);
            stringBuilder.append("'>");
        } else {
            stringBuilder.append("'>");
            for (PacketExtension packetExtension : this.items) {
                stringBuilder.append(packetExtension.toXML());
            }
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "Content [" + this.toXML() + "]";
    }

    public static enum ItemsElementType {
        items(PubSubElementType.ITEMS, "max_items"),
        retract(PubSubElementType.RETRACT, "notify");

        private PubSubElementType elem;
        private String att;

        private ItemsElementType(PubSubElementType pubSubElementType, String string2) {
            this.elem = pubSubElementType;
            this.att = string2;
        }

        public PubSubElementType getNodeElement() {
            return this.elem;
        }

        public String getElementAttribute() {
            return this.att;
        }
    }
}

