/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceLib {
    private static final Logger LOG = Logger.getLogger(ServiceLib.class.getName());

    private ServiceLib() {
    }

    static <T> T loadService(Class<T> clazz) {
        List<String> list = ServiceLib.loadServicesImplementations(clazz);
        for (String string : list) {
            T t = ServiceLib.attemptLoad(clazz, string);
            if (t == null) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Selected " + clazz.getSimpleName() + " implementation: " + t.getClass().getName());
            }
            return t;
        }
        throw new IllegalStateException("Could not load " + clazz.getName() + " implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadServicesImplementations(Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = System.getProperty(clazz.getName());
        if (string != null) {
            arrayList.add(string);
        }
        ClassLoader classLoader = ServiceLib.class.getClassLoader();
        URL uRL = classLoader.getResource("META-INF/services/" + clazz.getName());
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            inputStream = uRL.openStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.matches("\\s*(#.*)?")) continue;
                arrayList.add(string2.trim());
            }
        }
        catch (IOException iOException) {
            try {
                LOG.log(Level.WARNING, "Could not load services descriptor: " + uRL.toString(), iOException);
            }
            catch (Throwable throwable) {
                ServiceLib.finalClose(bufferedReader);
                ServiceLib.finalClose(inputStreamReader);
                ServiceLib.finalClose(inputStream);
                throw throwable;
            }
            ServiceLib.finalClose(bufferedReader);
            ServiceLib.finalClose(inputStreamReader);
            ServiceLib.finalClose(inputStream);
        }
        ServiceLib.finalClose(bufferedReader);
        ServiceLib.finalClose(inputStreamReader);
        ServiceLib.finalClose(inputStream);
        return arrayList;
    }

    private static <T> T attemptLoad(Class<T> clazz, String string) {
        ReflectiveOperationException reflectiveOperationException;
        Level level;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Attempting service load: " + string);
        }
        try {
            Class<?> clazz2 = Class.forName(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning(clazz2.getName() + " is not assignable to " + clazz.getName());
                }
                return null;
            }
            return clazz.cast(clazz2.newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            level = Level.FINEST;
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            level = Level.WARNING;
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            level = Level.WARNING;
            reflectiveOperationException = illegalAccessException;
        }
        LOG.log(level, "Could not load " + clazz.getSimpleName() + " instance: " + string, reflectiveOperationException);
        return null;
    }

    private static void finalClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.FINEST, "Could not close: " + closeable, iOException);
            }
        }
    }
}

