/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import org.jlibrtp.jlibrtp.core.DataFrame;
import org.jlibrtp.jlibrtp.core.Participant;
import org.jlibrtp.jlibrtp.core.PktBufNode;
import org.jlibrtp.jlibrtp.core.RTPSession;
import org.jlibrtp.jlibrtp.core.RtpPkt;

public class PktBuffer {
    RTPSession rtpSession;
    long SSRC;
    Participant p;
    int length = 0;
    PktBufNode oldest = null;
    PktBufNode newest = null;
    int lastSeqNumber = -1;
    long lastTimestamp = -1L;

    protected PktBuffer(RTPSession rtpSession, Participant p, RtpPkt aPkt) {
        PktBufNode newNode;
        this.rtpSession = rtpSession;
        this.p = p;
        this.SSRC = aPkt.getSsrc();
        this.oldest = newNode = new PktBufNode(aPkt);
        this.newest = newNode;
        this.length = 1;
    }

    protected synchronized int addPkt(RtpPkt aPkt) {
        if (aPkt == null) {
            System.out.println("! PktBuffer.addPkt(aPkt) aPkt was null");
            return -5;
        }
        long timeStamp = aPkt.getTimeStamp();
        PktBufNode newNode = new PktBufNode(aPkt);
        if (aPkt.getSsrc() != this.SSRC) {
            System.out.println("PktBuffer.addPkt() SSRCs don't match!");
        }
        int retVal = 0;
        if (this.rtpSession.pktBufBehavior > 0) {
            retVal = this.bufferedAddPkt(newNode);
        } else if (this.rtpSession.pktBufBehavior == 0) {
            retVal = this.filteredAddPkt(newNode);
        } else if (this.rtpSession.pktBufBehavior == -1) {
            retVal = this.unfilteredAddPkt(newNode);
        }
        return retVal;
    }

    private int unfilteredAddPkt(PktBufNode newNode) {
        if (this.oldest != null) {
            this.oldest.nextFrameQueueNode = newNode;
            newNode.prevFrameQueueNode = this.oldest;
            this.oldest = newNode;
        } else {
            this.oldest = newNode;
            this.newest = newNode;
        }
        return 0;
    }

    private int filteredAddPkt(PktBufNode newNode) {
        if (this.length == 0) {
            this.newest = newNode;
            this.oldest = newNode;
            this.length = 1;
        } else if (newNode.timeStamp > this.newest.timeStamp || newNode.seqNum > this.newest.seqNum && newNode.seqNum - this.newest.seqNum < 10) {
            newNode.nextFrameQueueNode = this.newest;
            this.newest.prevFrameQueueNode = newNode;
            this.newest = newNode;
            ++this.length;
        } else {
            return -1;
        }
        return 0;
    }

    private int bufferedAddPkt(PktBufNode newNode) {
        if (this.length == 0) {
            this.newest = newNode;
            this.oldest = newNode;
        } else if (newNode.timeStamp > this.newest.timeStamp || newNode.seqNum > this.newest.seqNum) {
            newNode.nextFrameQueueNode = this.newest;
            this.newest.prevFrameQueueNode = newNode;
            this.newest = newNode;
        } else {
            if (!this.pktOnTime(newNode.timeStamp, newNode.seqNum) && this.rtpSession.pktBufBehavior > -1) {
                return -1;
            }
            PktBufNode tmpNode = this.newest;
            while (tmpNode.timeStamp > newNode.timeStamp) {
                tmpNode = tmpNode.nextFrameQueueNode;
            }
            if (tmpNode.timeStamp == newNode.timeStamp && this.rtpSession.frameReconstruction && newNode.seqNum != tmpNode.seqNum) {
                int ret = this.addToFrame(tmpNode, newNode);
                if (ret != 0) {
                    return ret;
                }
            } else {
                if (tmpNode.timeStamp == newNode.timeStamp && newNode.seqNum == tmpNode.seqNum) {
                    return -1;
                }
                newNode.nextFrameQueueNode = tmpNode;
                newNode.prevFrameQueueNode = tmpNode.prevFrameQueueNode;
                if (newNode.prevFrameQueueNode != null) {
                    newNode.prevFrameQueueNode.nextFrameQueueNode = newNode;
                }
                tmpNode.prevFrameQueueNode = newNode;
                if (newNode.timeStamp > this.newest.timeStamp) {
                    this.newest = newNode;
                }
            }
        }
        ++this.length;
        return 0;
    }

    private int addToFrame(PktBufNode frameNode, PktBufNode newNode) {
        if (frameNode.seqNum < newNode.seqNum) {
            ++frameNode.pktCount;
            while (frameNode.nextFrameNode != null && frameNode.nextFrameNode.seqNum < newNode.seqNum) {
                frameNode = frameNode.nextFrameNode;
            }
            if (frameNode.nextFrameNode != null && frameNode.nextFrameNode.seqNum == newNode.seqNum) {
                return -2;
            }
            newNode.nextFrameNode = frameNode.nextFrameNode;
            frameNode.nextFrameNode = newNode;
        } else {
            newNode.nextFrameNode = frameNode;
            newNode.pktCount = frameNode.pktCount + 1;
            if (frameNode.nextFrameQueueNode != null) {
                frameNode.nextFrameQueueNode.prevFrameQueueNode = newNode;
                newNode.nextFrameQueueNode = frameNode.nextFrameQueueNode;
                frameNode.nextFrameQueueNode = null;
            }
            if (frameNode.prevFrameQueueNode != null) {
                frameNode.prevFrameQueueNode.nextFrameQueueNode = newNode;
                newNode.prevFrameQueueNode = frameNode.prevFrameQueueNode;
                frameNode.prevFrameQueueNode = null;
            }
            if (this.newest.timeStamp == newNode.timeStamp) {
                this.newest = newNode;
            }
        }
        return 0;
    }

    protected synchronized DataFrame popOldestFrame() {
        if (this.rtpSession.pktBufBehavior > 0) {
            return this.bufferedPopFrame();
        }
        return this.unbufferedPopFrame();
    }

    private DataFrame unbufferedPopFrame() {
        if (this.oldest != null) {
            PktBufNode retNode = this.oldest;
            this.popFrameQueueCleanup(retNode, retNode.seqNum);
            return new DataFrame(retNode, this.p, this.rtpSession.appIntf.frameSize(retNode.pkt.getPayloadType()));
        }
        return null;
    }

    private DataFrame bufferedPopFrame() {
        PktBufNode retNode = this.oldest;
        if (retNode != null && (retNode.seqNum == this.lastSeqNumber + 1 || retNode.seqNum == 0 || this.length > this.rtpSession.pktBufBehavior || this.lastSeqNumber < 0)) {
            DataFrame df = new DataFrame(retNode, this.p, this.rtpSession.appIntf.frameSize(this.oldest.pkt.getPayloadType()));
            this.popFrameQueueCleanup(retNode, df.lastSeqNum);
            return df;
        }
        return null;
    }

    private void popFrameQueueCleanup(PktBufNode retNode, int highestSeq) {
        if (1 == this.length) {
            this.newest = null;
            this.oldest = null;
        } else {
            this.oldest = this.oldest.prevFrameQueueNode;
            this.oldest.nextFrameQueueNode = null;
        }
        --this.length;
        this.lastSeqNumber = highestSeq;
        this.lastTimestamp = retNode.timeStamp;
    }

    protected int getLength() {
        return this.length;
    }

    protected boolean pktOnTime(long timeStamp, int seqNum) {
        if (this.lastSeqNumber == -1) {
            return true;
        }
        return !(seqNum >= this.lastSeqNumber ? this.lastSeqNumber < 3 && timeStamp < this.lastTimestamp : seqNum > 3 || timeStamp < this.lastTimestamp);
    }

    protected void debugPrint() {
        System.out.println("PktBuffer.debugPrint() : length " + this.length + " SSRC " + this.SSRC + " lastSeqNum:" + this.lastSeqNumber);
        PktBufNode tmpNode = this.oldest;
        int i = 0;
        while (tmpNode != null) {
            System.out.println("   " + i + " seqNum:" + tmpNode.seqNum + " timeStamp: " + tmpNode.timeStamp + " pktCount:" + tmpNode.pktCount);
            ++i;
            tmpNode = tmpNode.prevFrameQueueNode;
        }
    }
}

