/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

public class Form {
    public static final String TYPE_FORM = "form";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CANCEL = "cancel";
    public static final String TYPE_RESULT = "result";
    private DataForm dataForm;

    public static Form getFormFrom(Packet packet) {
        DataForm dataForm;
        PacketExtension packetExtension = packet.getExtension("x", "jabber:x:data");
        if (packetExtension != null && (dataForm = (DataForm)packetExtension).getReportedData() == null) {
            return new Form(dataForm);
        }
        return null;
    }

    public Form(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public Form(String string) {
        this.dataForm = new DataForm(string);
    }

    public void addField(FormField formField) {
        this.dataForm.addField(formField);
    }

    public void setAnswer(String string, String string2) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(formField.getType()) || "text-private".equals(formField.getType()) || "text-single".equals(formField.getType()) || "jid-single".equals(formField.getType()) || "hidden".equals(formField.getType()))) {
            throw new IllegalArgumentException("This field is not of type String.");
        }
        this.setAnswer(formField, (Object)string2);
    }

    public void setAnswer(String string, int n) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(formField.getType()) || "text-private".equals(formField.getType()) || "text-single".equals(formField.getType()))) {
            throw new IllegalArgumentException("This field is not of type int.");
        }
        this.setAnswer(formField, (Object)n);
    }

    public void setAnswer(String string, long l) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(formField.getType()) || "text-private".equals(formField.getType()) || "text-single".equals(formField.getType()))) {
            throw new IllegalArgumentException("This field is not of type long.");
        }
        this.setAnswer(formField, (Object)l);
    }

    public void setAnswer(String string, float f) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(formField.getType()) || "text-private".equals(formField.getType()) || "text-single".equals(formField.getType()))) {
            throw new IllegalArgumentException("This field is not of type float.");
        }
        this.setAnswer(formField, Float.valueOf(f));
    }

    public void setAnswer(String string, double d) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!("text-multi".equals(formField.getType()) || "text-private".equals(formField.getType()) || "text-single".equals(formField.getType()))) {
            throw new IllegalArgumentException("This field is not of type double.");
        }
        this.setAnswer(formField, (Object)d);
    }

    public void setAnswer(String string, boolean bl) {
        FormField formField = this.getField(string);
        if (formField == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (!"boolean".equals(formField.getType())) {
            throw new IllegalArgumentException("This field is not of type boolean.");
        }
        this.setAnswer(formField, (Object)(bl ? "1" : "0"));
    }

    private void setAnswer(FormField formField, Object object) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        formField.resetValues();
        formField.addValue(object.toString());
    }

    public void setAnswer(String string, List<String> list) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        FormField formField = this.getField(string);
        if (formField != null) {
            if (!("jid-multi".equals(formField.getType()) || "list-multi".equals(formField.getType()) || "list-single".equals(formField.getType()) || "hidden".equals(formField.getType()))) {
                throw new IllegalArgumentException("This field only accept list of values.");
            }
        } else {
            throw new IllegalArgumentException("Couldn't find a field for the specified variable.");
        }
        formField.resetValues();
        formField.addValues(list);
    }

    public void setDefaultAnswer(String string) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        FormField formField = this.getField(string);
        if (formField != null) {
            formField.resetValues();
            Iterator<String> iterator = formField.getValues();
            while (iterator.hasNext()) {
                formField.addValue(iterator.next());
            }
        } else {
            throw new IllegalArgumentException("Couldn't find a field for the specified variable.");
        }
    }

    public Iterator<FormField> getFields() {
        return this.dataForm.getFields();
    }

    public FormField getField(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Variable must not be null or blank.");
        }
        Iterator<FormField> iterator = this.getFields();
        while (iterator.hasNext()) {
            FormField formField = iterator.next();
            if (!string.equals(formField.getVariable())) continue;
            return formField;
        }
        return null;
    }

    public String getInstructions() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.dataForm.getInstructions();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getTitle() {
        return this.dataForm.getTitle();
    }

    public String getType() {
        return this.dataForm.getType();
    }

    public void setInstructions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.dataForm.setInstructions(arrayList);
    }

    public void setTitle(String string) {
        this.dataForm.setTitle(string);
    }

    public DataForm getDataFormToSend() {
        if (this.isSubmitType()) {
            DataForm dataForm = new DataForm(this.getType());
            Iterator<FormField> iterator = this.getFields();
            while (iterator.hasNext()) {
                FormField formField = iterator.next();
                if (!formField.getValues().hasNext()) continue;
                dataForm.addField(formField);
            }
            return dataForm;
        }
        return this.dataForm;
    }

    private boolean isFormType() {
        return TYPE_FORM.equals(this.dataForm.getType());
    }

    private boolean isSubmitType() {
        return TYPE_SUBMIT.equals(this.dataForm.getType());
    }

    public Form createAnswerForm() {
        if (!this.isFormType()) {
            throw new IllegalStateException("Only forms of type \"form\" could be answered");
        }
        Form form = new Form(TYPE_SUBMIT);
        Iterator<FormField> iterator = this.getFields();
        while (iterator.hasNext()) {
            FormField formField = iterator.next();
            if (formField.getVariable() == null) continue;
            FormField formField2 = new FormField(formField.getVariable());
            formField2.setType(formField.getType());
            form.addField(formField2);
            if (!"hidden".equals(formField.getType())) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<String> iterator2 = formField.getValues();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
            form.setAnswer(formField.getVariable(), arrayList);
        }
        return form;
    }
}

