/**
 * 
 */
package com.beem.project.beem.service;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * This class contains informations on a jabber contact.
 * @author darisk
 */
public class Contact implements Parcelable {

    public static final int CONTACT_STATUS_DISCONNECT = 100;
    public static final int CONTACT_STATUS_UNAVAILABLE = 200;
    public static final int CONTACT_STATUS_AWAY = 300;
    public static final int CONTACT_STATUS_BUSY = 400;
    public static final int CONTACT_STATUS_AVAILABLE = 500;
    public static final int CONTACT_STATUS_AVAILABLE_FOR_CHAT = 600;
    
    
    /**
     * Parcelable.Creator needs by Android.
     */
    public static final Parcelable.Creator<Contact> CREATOR = new Parcelable.Creator<Contact>() {

	@Override
	public Contact createFromParcel(Parcel source) {
	    return new Contact(source);
	}

	@Override
	public Contact[] newArray(int size) {
	    return new Contact[size];
	}
    };

    private String mJID;
    private int mID;
    private int mStatus;

    /**
     * @return the mID
     */
    public int getID() {
        return mID;
    }

    /**
     * @param mid the mID to set
     */
    public void setID(int mid) {
        mID = mid;
    }

    /**
     * @return the mStatus
     */
    public int getStatus() {
        return mStatus;
    }

    /**
     * @param status the mStatus to set
     */
    public void setStatus(int status) {
        mStatus = status;
    }

    /**
     * @return the mMsgState
     */
    public String getMMsgState() {
        return mMsgState;
    }

    /**
     * @param msgState the mMsgState to set
     */
    public void setMMsgState(String msgState) {
        mMsgState = msgState;
    }

    private String mMsgState;

    /**
     * Constructor.
     */
    public Contact() {
	// TODO Auto-generated constructor stub
    }

    /**
     * Constructor.
     * @param jid JID of the contact
     */
    public Contact(final String jid) {
	mJID = jid;
    }

    /**
     * Construct a contact from a parcel.
     * @param in parcel to use for construction
     */
    private Contact(final Parcel in) {
	mID = in.readInt();
	mStatus = in.readInt();
	mJID = in.readString();
	mMsgState = in.readString();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
	// TODO Auto-generated method stub
	dest.writeInt(mID);
	dest.writeInt(mStatus);
	dest.writeString(mJID);
	dest.writeString(mMsgState);
    }

    /**
     * Get the Jabber ID of the contact.
     * @return the Jabber ID
     */
    public String getJID() {
	return mJID;
    }

    /**
     * Set the Jabber ID of the contact.
     * @param mjid	the jabber ID to set
     */
    public void setJID(String mjid) {
	mJID = mjid;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int describeContents() {
	// TODO Auto-generated method stub
	return 0;
    }


}
