/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.security.SecureRandom;
import org.xbill.DNS.Client;

final class UDPClient
extends Client {
    private static final int EPHEMERAL_START = 1024;
    private static final int EPHEMERAL_STOP = 65535;
    private static final int EPHEMERAL_RANGE = 64511;
    private static SecureRandom prng = new SecureRandom();
    private static volatile boolean prng_initializing = true;
    private boolean bound = false;

    public UDPClient(long l) throws IOException {
        super(DatagramChannel.open(), l);
    }

    private void bind_random(InetSocketAddress inetSocketAddress) throws IOException {
        if (prng_initializing) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (prng_initializing) {
                return;
            }
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        for (int i = 0; i < 1024; ++i) {
            try {
                int n = prng.nextInt(64511) + 1024;
                InetSocketAddress inetSocketAddress2 = inetSocketAddress != null ? new InetSocketAddress(inetSocketAddress.getAddress(), n) : new InetSocketAddress(n);
                datagramChannel.socket().bind(inetSocketAddress2);
                this.bound = true;
                return;
            }
            catch (SocketException socketException) {
                continue;
            }
        }
    }

    void bind(SocketAddress socketAddress) throws IOException {
        if (socketAddress == null || socketAddress instanceof InetSocketAddress && ((InetSocketAddress)socketAddress).getPort() == 0) {
            this.bind_random((InetSocketAddress)socketAddress);
            if (this.bound) {
                return;
            }
        }
        if (socketAddress != null) {
            DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
            datagramChannel.socket().bind(socketAddress);
            this.bound = true;
        }
    }

    void connect(SocketAddress socketAddress) throws IOException {
        if (!this.bound) {
            this.bind(null);
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        datagramChannel.connect(socketAddress);
    }

    void send(byte[] byArray) throws IOException {
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        UDPClient.verboseLog("UDP write", byArray);
        datagramChannel.write(ByteBuffer.wrap(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] recv(int n) throws IOException {
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        byte[] byArray = new byte[n];
        this.key.interestOps(1);
        try {
            while (!this.key.isReadable()) {
                UDPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        long l = datagramChannel.read(ByteBuffer.wrap(byArray));
        if (l <= 0L) {
            throw new EOFException();
        }
        int n2 = (int)l;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        UDPClient.verboseLog("UDP read", byArray2);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress socketAddress, SocketAddress socketAddress2, byte[] byArray, int n, long l) throws IOException {
        UDPClient uDPClient = new UDPClient(l);
        try {
            uDPClient.bind(socketAddress);
            uDPClient.connect(socketAddress2);
            uDPClient.send(byArray);
            byte[] byArray2 = uDPClient.recv(n);
            return byArray2;
        }
        finally {
            uDPClient.cleanup();
        }
    }

    static byte[] sendrecv(SocketAddress socketAddress, byte[] byArray, int n, long l) throws IOException {
        return UDPClient.sendrecv(null, socketAddress, byArray, n, l);
    }

    static {
        new Thread(new Runnable(){

            public void run() {
                int n = prng.nextInt();
                prng_initializing = false;
            }
        }).start();
    }
}

